/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.GroupClauseSelectorSolver;
import org.sat4j.tools.SolverDecorator;
import org.sat4j.tools.xplain.DeletionStrategy;
import org.sat4j.tools.xplain.Explainer;
import org.sat4j.tools.xplain.MinimizationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighLevelXplain<T extends ISolver>
extends GroupClauseSelectorSolver<T>
implements Explainer {
    protected IVecInt assump;
    private MinimizationStrategy xplainStrategy = new DeletionStrategy();
    private static final long serialVersionUID = 1L;

    public HighLevelXplain(T t) {
        super(t);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    private IVecInt explanationKeys() throws TimeoutException {
        assert (!this.isSatisfiable(this.assump));
        Object t = this.decorated();
        if (t instanceof SolverDecorator) {
            t = ((SolverDecorator)t).decorated();
        }
        return this.xplainStrategy.explain((ISolver)t, this.varToHighLevel, this.assump);
    }

    @Override
    public int[] minimalExplanation() throws TimeoutException {
        Collection<Integer> collection = this.explain();
        int[] nArray = new int[collection.size()];
        int n = 0;
        for (int n2 : collection) {
            nArray[n++] = n2;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public Collection<Integer> explain() throws TimeoutException {
        IVecInt iVecInt = this.explanationKeys();
        HashSet<Integer> hashSet = new HashSet<Integer>(iVecInt.size());
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            hashSet.add((Integer)this.varToHighLevel.get(iteratorInt.next()));
        }
        return hashSet;
    }

    public void cancelExplanation() {
        this.xplainStrategy.cancelExplanationComputation();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        for (Integer n : this.varToHighLevel.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.findModel(vecInt);
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        for (Integer n : this.varToHighLevel.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.findModel(vecInt);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        for (Integer n : this.varToHighLevel.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt);
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        for (Integer n : this.varToHighLevel.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt, bl);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        for (Integer n : this.varToHighLevel.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        for (Integer n : this.varToHighLevel.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt, bl);
    }

    @Override
    public String toString(String string) {
        System.out.println(string + "High Level Explanation (MUS) enabled solver");
        System.out.println(string + this.xplainStrategy);
        return super.toString(string);
    }

    @Override
    public void setMinimizationStrategy(MinimizationStrategy minimizationStrategy) {
        this.xplainStrategy = minimizationStrategy;
    }
}

