/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.constraints.MixedDataStructureDanielWL;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.DimacsOutputSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverFactory
extends ASolverFactory<ISolver> {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    public static <L extends ILits> Solver<DataStructureFactory> newMiniSAT(DataStructureFactory dataStructureFactory) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver((LearningStrategy)miniSATLearning, dataStructureFactory, (IOrder)new VarOrderHeap(), (RestartStrategy)new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static ISolver newDefault() {
        Solver<DataStructureFactory> solver = SolverFactory.newMiniSAT((DataStructureFactory)new MixedDataStructureDanielWL());
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newSAT() {
        return org.sat4j.pb.SolverFactory.newSAT();
    }

    public static ISolver newUNSAT() {
        return org.sat4j.pb.SolverFactory.newUNSAT();
    }

    public static ISolver newCuttingPlanes() {
        return org.sat4j.pb.SolverFactory.newCuttingPlanes();
    }

    public ISolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public static ISolver newLight() {
        return SolverFactory.newMiniSAT((DataStructureFactory)new MixedDataStructureDanielWL());
    }

    public ISolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static ISolver newDimacsOutput() {
        return new DimacsOutputSolver();
    }
}

