/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import org.sat4j.ExitCode;
import org.sat4j.ILauncherMode;
import org.sat4j.core.ASolverFactory;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ModelIteratorToSATAdapter;
import org.sat4j.tools.SearchEnumeratorListener;
import org.sat4j.tools.SearchMinOneListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLauncher
implements Serializable,
ILogAble {
    private static final long serialVersionUID = 1L;
    public static final String COMMENT_PREFIX = "c ";
    protected long beginTime;
    protected ExitCode exitCode = ExitCode.UNKNOWN;
    protected Reader reader;
    protected transient PrintWriter out = new PrintWriter(System.out, true);
    private boolean displaySolutionLine = true;
    protected transient Thread shutdownHook = new Thread(){

        public void run() {
            AbstractLauncher.this.displayResult();
        }
    };
    protected ISolver solver;
    protected IProblem problem;
    public boolean silent = false;
    protected boolean prime = System.getProperty("prime") != null;
    private ILauncherMode launcherMode = ILauncherMode.DECISION;

    protected void setLauncherMode(ILauncherMode iLauncherMode) {
        this.launcherMode = iLauncherMode;
    }

    protected void setIncomplete(boolean bl) {
        this.launcherMode.setIncomplete(bl);
    }

    protected AbstractLauncher() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected void displayResult() {
        this.launcherMode.displayResult(this.solver, this.problem, this, this.out, this.reader, this.beginTime, this.displaySolutionLine);
    }

    public abstract void usage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void displayHeader() {
        Object object;
        this.displayLicense();
        URL uRL = AbstractLauncher.class.getResource("/sat4j.version");
        if (uRL == null) {
            this.log("no version file found!!!");
        } else {
            object = null;
            try {
                object = new BufferedReader(new InputStreamReader(uRL.openStream()));
                this.log("version " + ((BufferedReader)object).readLine());
            }
            catch (IOException iOException) {
                this.log("c ERROR: " + iOException.getMessage());
            }
            finally {
                if (object != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (IOException iOException) {
                        this.log("c ERROR: " + iOException.getMessage());
                    }
                }
            }
        }
        object = System.getProperties();
        String[] stringArray = new String[]{"java.runtime.name", "java.vm.name", "java.vm.version", "java.vm.vendor", "sun.arch.data.model", "java.version", "os.name", "os.version", "os.arch"};
        for (String string : stringArray) {
            this.log(string + (string.length() < 14 ? "\t\t" : "\t") + ((Properties)object).getProperty(string));
        }
        Runtime runtime = Runtime.getRuntime();
        this.log("Free memory \t\t" + runtime.freeMemory());
        this.log("Max memory \t\t" + runtime.maxMemory());
        this.log("Total memory \t\t" + runtime.totalMemory());
        this.log("Number of processors \t" + runtime.availableProcessors());
    }

    public void displayLicense() {
        this.log("SAT4J: a SATisfiability library for Java (c) 2004-2012 Artois University and CNRS");
        this.log("This is free software under the dual EPL/GNU LGPL licenses.");
        this.log("See www.sat4j.org for details.");
    }

    protected IProblem readProblem(String string) throws ParseFormatException, IOException, ContradictionException {
        this.log("solving " + string);
        this.log("reading problem ... ");
        this.reader = this.createReader(this.solver, string);
        IProblem iProblem = this.reader.parseInstance(string);
        this.log("... done. Wall clock time " + (double)(System.currentTimeMillis() - this.beginTime) / 1000.0 + "s.");
        this.log("declared #vars     " + iProblem.nVars());
        if (this.solver.nVars() < this.solver.realNumberOfVariables()) {
            this.log("internal #vars     " + this.solver.realNumberOfVariables());
        }
        this.log("#constraints  " + iProblem.nConstraints());
        iProblem.printInfos(this.out);
        return iProblem;
    }

    protected abstract Reader createReader(ISolver var1, String var2);

    public void run(String[] stringArray) {
        try {
            Object object;
            String string;
            this.displayHeader();
            this.solver = this.configureSolver(stringArray);
            if (this.solver == null) {
                this.usage();
                return;
            }
            if (!this.silent) {
                this.solver.setVerbose(true);
            }
            if ((string = System.getProperty("all")) != null) {
                if ("external".equals(string)) {
                    this.solver = new ModelIteratorToSATAdapter(this.solver, this.launcherMode);
                    System.out.println(this.solver.getLogPrefix() + "model enumeration using the external way");
                } else {
                    object = new SearchEnumeratorListener(this.launcherMode);
                    this.solver.setSearchListener(object);
                    System.out.println(this.solver.getLogPrefix() + "model enumeration using the internal way");
                }
            }
            if (System.getProperty("minone") != null) {
                object = new SearchMinOneListener(this.launcherMode);
                this.solver.setSearchListener(object);
            }
            if ((object = this.getInstanceName(stringArray)) == null) {
                this.usage();
                return;
            }
            this.beginTime = System.currentTimeMillis();
            this.problem = this.readProblem((String)object);
            try {
                this.solve(this.problem);
            }
            catch (TimeoutException timeoutException) {
                this.log("timeout");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("FATAL " + fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            System.err.println("FATAL " + iOException.getLocalizedMessage());
        }
        catch (ContradictionException contradictionException) {
            this.exitCode = ExitCode.UNSATISFIABLE;
            this.launcherMode.setExitCode(ExitCode.UNSATISFIABLE);
            this.log("(trivial inconsistency)");
        }
        catch (ParseFormatException parseFormatException) {
            System.err.println("FATAL " + parseFormatException.getLocalizedMessage());
        }
    }

    protected abstract String getInstanceName(String[] var1);

    protected abstract ISolver configureSolver(String[] var1);

    @Override
    public void log(String string) {
        if (!this.silent) {
            this.out.println(COMMENT_PREFIX + string);
        }
    }

    protected void solve(IProblem iProblem) throws TimeoutException {
        this.launcherMode.solve(iProblem, this.reader, this, this.out, this.beginTime);
        this.setExitCode(this.launcherMode.getCurrentExitCode());
    }

    protected void setDisplaySolutionLine(boolean bl) {
        this.displaySolutionLine = bl;
    }

    public final void setExitCode(ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public final ExitCode getExitCode() {
        return this.exitCode;
    }

    public final long getBeginTime() {
        return this.beginTime;
    }

    public final Reader getReader() {
        return this.reader;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    protected void setSilent(boolean bl) {
        this.silent = bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.out = new PrintWriter(System.out, true);
        this.shutdownHook = new Thread(){

            public void run() {
                AbstractLauncher.this.displayResult();
            }
        };
    }

    protected <T extends ISolver> void showAvailableSolvers(ASolverFactory<T> aSolverFactory) {
        this.showAvailableSolvers(aSolverFactory, "");
    }

    protected <T extends ISolver> void showAvailableSolvers(ASolverFactory<T> aSolverFactory, String string) {
        if (aSolverFactory != null) {
            String[] stringArray;
            if (string.length() > 0) {
                this.log("Available solvers for " + string + ": ");
            } else {
                this.log("Available solvers: ");
            }
            for (String string2 : stringArray = aSolverFactory.solverNames()) {
                this.log(string2);
            }
        }
    }
}

