/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.constraints.MixedDataStructureDanielWL;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.DimacsOutputSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverFactory
extends ASolverFactory<ISolver> {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    public static <L extends ILits> Solver<DataStructureFactory> newMiniSAT(DataStructureFactory dataStructureFactory) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver<DataStructureFactory> solver = new Solver<DataStructureFactory>(miniSATLearning, dataStructureFactory, new VarOrderHeap(), new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newDefault() {
        Solver<DataStructureFactory> solver = SolverFactory.newMiniSAT(new MixedDataStructureDanielWL());
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newSAT() {
        return org.sat4j.pb.SolverFactory.newSAT();
    }

    public static ISolver newUNSAT() {
        return org.sat4j.pb.SolverFactory.newUNSAT();
    }

    public static ISolver newCuttingPlanes() {
        return org.sat4j.pb.SolverFactory.newCuttingPlanes();
    }

    @Override
    public ISolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public static ISolver newLight() {
        return SolverFactory.newMiniSAT(new MixedDataStructureDanielWL());
    }

    @Override
    public ISolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static ISolver newDimacsOutput() {
        return new DimacsOutputSolver();
    }
}

