/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.IteratorInt;

public class ConflictMap
extends MapPb
implements IConflict {
    private final ILits voc;
    protected boolean hasBeenReduced = false;
    protected long numberOfReductions = 0L;
    protected BigInteger currentSlack;
    protected int currentLevel;
    protected VecInt[] byLevel;
    protected BigInteger coefMult = BigInteger.ZERO;
    protected BigInteger coefMultCons = BigInteger.ZERO;
    private BigInteger possReducedCoefs = BigInteger.ZERO;

    public static IConflict createConflict(PBConstr pBConstr, int n) {
        return new ConflictMap(pBConstr, n);
    }

    ConflictMap(PBConstr pBConstr, int n) {
        super(pBConstr);
        this.voc = pBConstr.getVocabulary();
        this.currentLevel = n;
        this.initStructures();
    }

    private void initStructures() {
        this.currentSlack = BigInteger.ZERO;
        this.byLevel = new VecInt[ConflictMap.levelToIndex(this.currentLevel) + 1];
        for (int i = 0; i < this.size(); ++i) {
            int n;
            int n2 = this.weightedLits.getLit(i);
            int n3 = this.voc.getLevel(n2);
            BigInteger bigInteger = this.weightedLits.getCoef(i);
            if (!(bigInteger.signum() <= 0 || this.voc.isFalsified(n2) && n3 != this.currentLevel)) {
                this.currentSlack = this.currentSlack.add(bigInteger);
            }
            if (this.byLevel[n = ConflictMap.levelToIndex(n3)] == null) {
                this.byLevel[n] = new VecInt();
            }
            this.byLevel[n].push(n2);
        }
    }

    private static int levelToIndex(int n) {
        return n + 1;
    }

    private static int indexToLevel(int n) {
        return n - 1;
    }

    public BigInteger resolve(PBConstr pBConstr, int n, VarActivityListener varActivityListener) {
        assert (n > 1);
        int n2 = n ^ 1;
        if (pBConstr == null || !this.weightedLits.containsKey(n2)) {
            int n3 = ConflictMap.levelToIndex(this.voc.getLevel(n));
            int n4 = 0;
            if (this.byLevel[n3] != null) {
                if (this.byLevel[n3].contains(n)) {
                    n4 = n;
                    assert (this.weightedLits.containsKey(n));
                } else if (this.byLevel[n3].contains(n2)) {
                    n4 = n2;
                    assert (this.weightedLits.containsKey(n2));
                }
            }
            if (n4 > 0) {
                this.byLevel[n3].remove(n4);
                if (this.byLevel[0] == null) {
                    this.byLevel[0] = new VecInt();
                }
                this.byLevel[0].push(n4);
            }
            return this.degree;
        }
        assert (this.slackConflict().signum() <= 0);
        assert (this.degree.signum() >= 0);
        BigInteger[] bigIntegerArray = null;
        BigInteger bigInteger = pBConstr.getDegree();
        int n5 = 0;
        while (pBConstr.get(n5) != n) {
            ++n5;
        }
        assert (pBConstr.get(n5) == n);
        assert (pBConstr.getCoef(n5) != BigInteger.ZERO);
        if (pBConstr.getCoef(n5).equals(BigInteger.ONE)) {
            this.coefMultCons = this.weightedLits.get(n2);
            this.coefMult = BigInteger.ONE;
            bigInteger = bigInteger.multiply(this.coefMultCons);
        } else {
            if (this.weightedLits.get(n2).equals(BigInteger.ONE)) {
                this.coefMult = pBConstr.getCoef(n5);
                this.coefMultCons = BigInteger.ONE;
                this.degree = this.degree.multiply(this.coefMult);
            } else {
                IWatchPb iWatchPb = (IWatchPb)pBConstr;
                bigIntegerArray = iWatchPb.getCoefs();
                assert (ConflictMap.positiveCoefs(bigIntegerArray));
                bigInteger = this.reduceUntilConflict(n, n5, bigIntegerArray, iWatchPb);
                bigInteger = bigInteger.multiply(this.coefMultCons);
                this.degree = this.degree.multiply(this.coefMult);
            }
            if (!this.coefMult.equals(BigInteger.ONE)) {
                for (int i = 0; i < this.size(); ++i) {
                    this.changeCoef(i, this.weightedLits.getCoef(i).multiply(this.coefMult));
                }
            }
        }
        assert (this.slackConflict().signum() <= 0);
        this.degree = this.cuttingPlane(pBConstr, bigInteger, bigIntegerArray, this.coefMultCons, varActivityListener);
        assert (!this.weightedLits.containsKey(n));
        assert (!this.weightedLits.containsKey(n2));
        assert (this.getLevelByLevel(n) == -1);
        assert (this.getLevelByLevel(n2) == -1);
        assert (this.degree.signum() > 0);
        assert (this.slackConflict().signum() <= 0);
        this.degree = this.saturation();
        assert (this.slackConflict().signum() <= 0);
        return this.degree;
    }

    protected BigInteger reduceUntilConflict(int n, int n2, BigInteger[] bigIntegerArray, IWatchPb iWatchPb) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = BigInteger.ONE.negate();
        BigInteger bigInteger3 = BigInteger.ZERO;
        BigInteger bigInteger4 = this.slackConflict();
        BigInteger bigInteger5 = iWatchPb.getDegree();
        BigInteger bigInteger6 = BigInteger.ZERO;
        BigInteger bigInteger7 = this.weightedLits.get(n ^ 1);
        this.possReducedCoefs = this.possConstraint(iWatchPb, bigIntegerArray);
        do {
            if (bigInteger2.signum() >= 0) {
                assert (bigInteger3.signum() > 0);
                BigInteger bigInteger8 = this.reduceInConstraint(iWatchPb, bigIntegerArray, n2, bigInteger5);
                assert (bigInteger8.compareTo(bigInteger5) < 0 && bigInteger8.compareTo(BigInteger.ONE) >= 0);
                bigInteger5 = bigInteger8;
            }
            assert (this.weightedLits.get(n ^ 1).signum() > 0);
            assert (bigIntegerArray[n2].signum() > 0);
            if (!bigIntegerArray[n2].equals(bigInteger6)) {
                assert (bigInteger7.equals(this.weightedLits.get(n ^ 1)));
                BigInteger bigInteger9 = ConflictMap.ppcm(bigIntegerArray[n2], bigInteger7);
                assert (bigInteger9.signum() > 0);
                this.coefMult = bigInteger9.divide(bigInteger7);
                this.coefMultCons = bigInteger9.divide(bigIntegerArray[n2]);
                assert (this.coefMultCons.signum() > 0);
                assert (this.coefMult.signum() > 0);
                assert (this.coefMult.multiply(bigInteger7).equals(this.coefMultCons.multiply(bigIntegerArray[n2])));
                bigInteger6 = bigIntegerArray[n2];
            }
            bigInteger3 = this.possReducedCoefs.subtract(bigInteger5).multiply(this.coefMultCons);
            assert (bigInteger3.equals(iWatchPb.slackConstraint(bigIntegerArray, bigInteger5).multiply(this.coefMultCons)));
            assert (bigInteger4.equals(this.slackConflict()));
            bigInteger = bigInteger4.multiply(this.coefMult);
            assert (bigInteger.signum() <= 0);
        } while ((bigInteger2 = bigInteger3.add(bigInteger)).signum() >= 0);
        assert (this.coefMult.multiply(this.weightedLits.get(n ^ 1)).equals(this.coefMultCons.multiply(bigIntegerArray[n2])));
        return bigInteger5;
    }

    private BigInteger possConstraint(IWatchPb iWatchPb, BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < iWatchPb.size(); ++i) {
            if (this.voc.isFalsified(iWatchPb.get(i))) continue;
            assert (bigIntegerArray[i].signum() >= 0);
            bigInteger = bigInteger.add(bigIntegerArray[i]);
        }
        return bigInteger;
    }

    public BigInteger slackConflict() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.size(); ++i) {
            BigInteger bigInteger2 = this.weightedLits.getCoef(i);
            if (bigInteger2.signum() == 0 || this.voc.isFalsified(this.weightedLits.getLit(i))) continue;
            assert (bigInteger2.signum() > 0);
            bigInteger = bigInteger.add(bigInteger2);
        }
        return bigInteger.subtract(this.degree);
    }

    public boolean oldIsAssertive(int n) {
        BigInteger bigInteger = this.computeSlack(n).subtract(this.degree);
        if (bigInteger.signum() < 0) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            BigInteger bigInteger2 = this.weightedLits.getCoef(i);
            int n2 = this.weightedLits.getLit(i);
            if (bigInteger2.signum() <= 0 || !this.voc.isUnassigned(n2) && this.voc.getLevel(n2) < n || bigInteger.compareTo(bigInteger2) >= 0) continue;
            return true;
        }
        return false;
    }

    private BigInteger computeSlack(int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.size(); ++i) {
            BigInteger bigInteger2 = this.weightedLits.getCoef(i);
            int n2 = this.weightedLits.getLit(i);
            if (bigInteger2.signum() <= 0 || this.voc.isFalsified(n2) && this.voc.getLevel(n2) < n) continue;
            bigInteger = bigInteger.add(bigInteger2);
        }
        return bigInteger;
    }

    public boolean isAssertive(int n) {
        assert (n <= this.currentLevel);
        assert (n <= this.currentLevel);
        this.currentLevel = n;
        BigInteger bigInteger = this.currentSlack.subtract(this.degree);
        if (bigInteger.signum() < 0) {
            return false;
        }
        return this.isImplyingLiteral(bigInteger);
    }

    private boolean isImplyingLiteral(BigInteger bigInteger) {
        int n;
        int n2;
        Object object;
        int n3 = ConflictMap.levelToIndex(-1);
        if (this.byLevel[n3] != null) {
            object = this.byLevel[n3].iterator();
            while (object.hasNext()) {
                n2 = object.next();
                if (bigInteger.compareTo(this.weightedLits.get(n2)) >= 0) continue;
                this.assertiveLiteral = this.weightedLits.getFromAllLits(n2);
                return true;
            }
        }
        if (this.byLevel[n = ConflictMap.levelToIndex(this.currentLevel)] != null) {
            IteratorInt iteratorInt = this.byLevel[n].iterator();
            while (iteratorInt.hasNext()) {
                n2 = iteratorInt.next();
                object = this.weightedLits.get(n2);
                if (object == null || bigInteger.compareTo((BigInteger)object) >= 0) continue;
                this.assertiveLiteral = this.weightedLits.getFromAllLits(n2);
                return true;
            }
        }
        return false;
    }

    private boolean isImplyingLiteralOrdered(int n, BigInteger bigInteger) {
        for (int i = 0; i < this.size(); ++i) {
            int n2 = this.weightedLits.getLit(i);
            int n3 = this.voc.getLevel(n2);
            if (n3 < n && !this.voc.isUnassigned(n2) || bigInteger.compareTo(this.weightedLits.getCoef(i)) >= 0) continue;
            return true;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger.gcd(bigInteger2)).multiply(bigInteger2);
    }

    public BigInteger reduceInConstraint(IWatchPb iWatchPb, BigInteger[] bigIntegerArray, int n, BigInteger bigInteger) {
        int n2;
        assert (bigInteger.compareTo(BigInteger.ONE) > 0);
        int n3 = -1;
        int n4 = iWatchPb.size();
        for (n2 = 0; n2 < n4 && n3 == -1; ++n2) {
            if (bigIntegerArray[n2].signum() == 0 || !this.voc.isUnassigned(iWatchPb.get(n2))) continue;
            assert (bigIntegerArray[n2].compareTo(bigInteger) < 0);
            n3 = n2;
        }
        if (n3 == -1) {
            for (n2 = 0; n2 < n4 && n3 == -1; ++n2) {
                if (bigIntegerArray[n2].signum() == 0 || !this.voc.isSatisfied(iWatchPb.get(n2)) || n2 == n) continue;
                n3 = n2;
            }
        }
        assert (n3 != -1);
        assert (n3 != n);
        BigInteger bigInteger2 = bigInteger.subtract(bigIntegerArray[n3]);
        this.possReducedCoefs = this.possReducedCoefs.subtract(bigIntegerArray[n3]);
        bigIntegerArray[n3] = BigInteger.ZERO;
        assert (this.possReducedCoefs.equals(this.possConstraint(iWatchPb, bigIntegerArray)));
        bigInteger2 = this.saturation(bigIntegerArray, bigInteger2, iWatchPb);
        assert (bigIntegerArray[n].signum() > 0);
        assert (bigInteger.compareTo(bigInteger2) > 0);
        assert (this.possReducedCoefs.equals(this.possConstraint(iWatchPb, bigIntegerArray)));
        return bigInteger2;
    }

    private BigInteger saturation(BigInteger[] bigIntegerArray, BigInteger bigInteger, IWatchPb iWatchPb) {
        int n;
        assert (bigInteger.signum() > 0);
        BigInteger bigInteger2 = bigInteger;
        boolean bl = true;
        for (n = 0; n < bigIntegerArray.length; ++n) {
            int n2 = bigIntegerArray[n].compareTo(bigInteger);
            if (n2 > 0) {
                if (!this.voc.isFalsified(iWatchPb.get(n))) {
                    this.possReducedCoefs = this.possReducedCoefs.subtract(bigIntegerArray[n]);
                    this.possReducedCoefs = this.possReducedCoefs.add(bigInteger);
                }
                bigIntegerArray[n] = bigInteger;
                continue;
            }
            if (n2 >= 0 || bigIntegerArray[n].signum() <= 0) continue;
            bl = false;
        }
        if (bl && !bigInteger.equals(BigInteger.ONE)) {
            this.possReducedCoefs = BigInteger.ZERO;
            bigInteger2 = BigInteger.ONE;
            for (n = 0; n < bigIntegerArray.length; ++n) {
                if (bigIntegerArray[n].signum() <= 0) continue;
                bigIntegerArray[n] = BigInteger.ONE;
                if (this.voc.isFalsified(iWatchPb.get(n))) continue;
                this.possReducedCoefs = this.possReducedCoefs.add(BigInteger.ONE);
            }
        }
        return bigInteger2;
    }

    private static boolean positiveCoefs(BigInteger[] bigIntegerArray) {
        for (BigInteger bigInteger : bigIntegerArray) {
            if (bigInteger.signum() > 0) continue;
            return false;
        }
        return true;
    }

    public int getBacktrackLevel(int n) {
        int n2 = ConflictMap.levelToIndex(n) - 1;
        int n3 = ConflictMap.levelToIndex(0);
        BigInteger bigInteger = this.computeSlack(0).subtract(this.degree);
        int n4 = 0;
        for (int i = n3; i <= n2; ++i) {
            if (this.byLevel[i] == null) continue;
            int n5 = ConflictMap.indexToLevel(i);
            assert (this.computeSlack(n5).subtract(this.degree).equals(bigInteger));
            if (this.isImplyingLiteralOrdered(n5, bigInteger)) break;
            VecInt vecInt = this.byLevel[i];
            IteratorInt iteratorInt = vecInt.iterator();
            while (iteratorInt.hasNext()) {
                int n6 = iteratorInt.next();
                if (!this.voc.isFalsified(n6) || this.voc.getLevel(n6) != ConflictMap.indexToLevel(i)) continue;
                bigInteger = bigInteger.subtract(this.weightedLits.get(n6));
            }
            if (vecInt.isEmpty()) continue;
            n4 = n5;
        }
        assert (n4 == this.oldGetBacktrackLevel(n));
        return n4;
    }

    public int oldGetBacktrackLevel(int n) {
        int n2;
        int n3;
        int n4 = n;
        assert (this.oldIsAssertive(n4));
        int n5 = -1;
        for (n3 = 0; n3 < this.size(); ++n3) {
            n2 = this.voc.getLevel(this.weightedLits.getLit(n3));
            if (n2 >= n4 || n2 <= n5 || !this.oldIsAssertive(n2)) continue;
            n4 = n2;
        }
        n3 = 0;
        for (int i = 0; i < this.size(); ++i) {
            n2 = this.voc.getLevel(this.weightedLits.getLit(i));
            if (n2 <= n3 || n2 >= n4) continue;
            n3 = n2;
        }
        return n3;
    }

    public void updateSlack(int n) {
        int n2 = ConflictMap.levelToIndex(n);
        if (this.byLevel[n2] != null) {
            IteratorInt iteratorInt = this.byLevel[n2].iterator();
            while (iteratorInt.hasNext()) {
                int n3 = iteratorInt.next();
                if (!this.voc.isFalsified(n3)) continue;
                this.currentSlack = this.currentSlack.add(this.weightedLits.get(n3));
            }
        }
    }

    void increaseCoef(int n, BigInteger bigInteger) {
        if (!this.voc.isFalsified(n) || this.voc.getLevel(n) == this.currentLevel) {
            this.currentSlack = this.currentSlack.add(bigInteger);
        }
        assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(n))].contains(n));
        super.increaseCoef(n, bigInteger);
    }

    void decreaseCoef(int n, BigInteger bigInteger) {
        if (!this.voc.isFalsified(n) || this.voc.getLevel(n) == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(bigInteger);
        }
        assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(n))].contains(n));
        super.decreaseCoef(n, bigInteger);
    }

    void setCoef(int n, BigInteger bigInteger) {
        int n2 = this.voc.getLevel(n);
        if (!this.voc.isFalsified(n) || n2 == this.currentLevel) {
            if (this.weightedLits.containsKey(n)) {
                this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(n));
            }
            this.currentSlack = this.currentSlack.add(bigInteger);
        }
        int n3 = ConflictMap.levelToIndex(n2);
        if (!this.weightedLits.containsKey(n)) {
            if (this.byLevel[n3] == null) {
                this.byLevel[n3] = new VecInt();
            }
            this.byLevel[n3].push(n);
        }
        assert (this.byLevel[n3] != null);
        assert (this.byLevel[n3].contains(n));
        super.setCoef(n, bigInteger);
    }

    void changeCoef(int n, BigInteger bigInteger) {
        int n2 = this.weightedLits.getLit(n);
        int n3 = this.voc.getLevel(n2);
        if (!this.voc.isFalsified(n2) || n3 == this.currentLevel) {
            if (this.weightedLits.containsKey(n2)) {
                this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(n2));
            }
            this.currentSlack = this.currentSlack.add(bigInteger);
        }
        int n4 = ConflictMap.levelToIndex(n3);
        assert (this.weightedLits.containsKey(n2));
        assert (this.byLevel[n4] != null);
        assert (this.byLevel[n4].contains(n2));
        super.changeCoef(n, bigInteger);
    }

    void removeCoef(int n) {
        int n2 = this.voc.getLevel(n);
        if (!this.voc.isFalsified(n) || n2 == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(n));
        }
        int n3 = ConflictMap.levelToIndex(n2);
        assert (n3 < this.byLevel.length);
        assert (this.byLevel[n3] != null);
        assert (this.byLevel[n3].contains(n));
        this.byLevel[n3].remove(n);
        super.removeCoef(n);
    }

    private int getLevelByLevel(int n) {
        for (int i = 0; i < this.byLevel.length; ++i) {
            if (this.byLevel[i] == null || !this.byLevel[i].contains(n)) continue;
            return i;
        }
        return -1;
    }

    public boolean slackIsCorrect(int n) {
        return this.currentSlack.equals(this.computeSlack(n));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            int n = this.weightedLits.getLit(i);
            stringBuffer.append(this.weightedLits.getCoef(i));
            stringBuffer.append(".");
            stringBuffer.append(Lits.toString(n));
            stringBuffer.append(" ");
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(n));
            stringBuffer.append("@");
            stringBuffer.append(this.voc.getLevel(n));
            stringBuffer.append("]");
        }
        return stringBuffer.toString() + " >= " + this.degree;
    }

    public boolean hasBeenReduced() {
        return this.hasBeenReduced;
    }

    public long getNumberOfReductions() {
        return this.numberOfReductions;
    }
}

