/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;

public final class MaxWatchPb
extends WatchPb {
    private static final long serialVersionUID = 1L;
    public static final int LIMIT_FOR_MAP = 100;
    private BigInteger watchCumul = BigInteger.ZERO;
    private final Map<Integer, BigInteger> litToCoeffs;

    private MaxWatchPb(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        if (this.coefs.length > 100) {
            this.litToCoeffs = new HashMap<Integer, BigInteger>(this.coefs.length);
            for (int i = 0; i < this.coefs.length; ++i) {
                this.litToCoeffs.put(this.lits[i], this.coefs[i]);
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    private MaxWatchPb(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        super(nArray, bigIntegerArray, bigInteger, bigInteger2);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        if (bigIntegerArray.length > 100) {
            this.litToCoeffs = new HashMap<Integer, BigInteger>(this.coefs.length);
            for (int i = 0; i < this.coefs.length; ++i) {
                this.litToCoeffs.put(this.lits[i], this.coefs[i]);
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul.equals(BigInteger.ZERO));
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) {
                if (!this.learnt) continue;
                this.voc.undos(this.lits[i] ^ 1).push(this);
                this.voc.watch(this.lits[i] ^ 1, this);
                continue;
            }
            this.voc.watch(this.lits[i] ^ 1, this);
            this.watchCumul = this.watchCumul.add(this.coefs[i]);
        }
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
        if (!this.learnt && this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        for (int i = 0; i < this.coefs.length && this.watchCumul.subtract(this.coefs[i]).compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        BigInteger bigInteger;
        this.voc.watch(n, this);
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0) : "" + this.watchCumul + "/" + this.computeLeftSide() + ":" + this.learnt;
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            bigInteger = this.coefs[n2];
        } else {
            bigInteger = this.litToCoeffs.get(n ^ 1);
        }
        BigInteger bigInteger2 = this.watchCumul.subtract(bigInteger);
        if (bigInteger2.compareTo(this.degree) < 0) {
            assert (!this.isSatisfiable());
            return false;
        }
        this.voc.undos(n).push(this);
        this.watchCumul = bigInteger2;
        BigInteger bigInteger3 = this.watchCumul.subtract(this.degree);
        for (int i = 0; i < this.coefs.length && bigInteger3.compareTo(this.coefs[i]) < 0; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            assert (!this.isSatisfiable());
            return false;
        }
        assert (this.learnt || this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.voc.watches(this.lits[i] ^ 1).remove(this);
        }
    }

    public void undo(int n) {
        BigInteger bigInteger;
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            bigInteger = this.coefs[n2];
        } else {
            bigInteger = this.litToCoeffs.get(n ^ 1);
        }
        this.watchCumul = this.watchCumul.add(bigInteger);
    }

    public static MaxWatchPb normalizedMaxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) throws ContradictionException {
        MaxWatchPb maxWatchPb = new MaxWatchPb(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
        if (maxWatchPb.degree.signum() <= 0) {
            return null;
        }
        maxWatchPb.computeWatches();
        maxWatchPb.computePropagation(unitPropagationListener);
        return maxWatchPb;
    }

    public static WatchPb normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MaxWatchPb(iLits, iDataStructurePB);
    }
}

