/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPbLongCP;
import org.sat4j.specs.ContradictionException;

public final class MaxWatchPbLongCP
extends WatchPbLongCP {
    private static final long serialVersionUID = 1L;
    private long watchCumul = 0L;
    private final Map<Integer, Long> litToCoeffs;

    private MaxWatchPbLongCP(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = 0L;
        if (this.coefs.length > 100) {
            this.litToCoeffs = new HashMap<Integer, Long>(this.coefs.length);
            for (int i = 0; i < this.coefs.length; ++i) {
                this.litToCoeffs.put(this.lits[i], this.coefs[i]);
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    private MaxWatchPbLongCP(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        super(nArray, bigIntegerArray, bigInteger, bigInteger2);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = 0L;
        if (bigIntegerArray.length > 100) {
            this.litToCoeffs = new HashMap<Integer, Long>(this.coefs.length);
            for (int i = 0; i < this.coefs.length; ++i) {
                this.litToCoeffs.put(this.lits[i], this.coefs[i]);
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul == 0L);
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) {
                if (!this.learnt) continue;
                this.voc.undos(this.lits[i] ^ 1).push(this);
                this.voc.watch(this.lits[i] ^ 1, this);
                continue;
            }
            this.voc.watch(this.lits[i] ^ 1, this);
            this.watchCumul += this.coefs[i];
        }
        assert (this.watchCumul >= this.computeLeftSide());
        if (!this.learnt && this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        for (int i = 0; i < this.coefs.length && this.watchCumul - this.coefs[i] < this.degree; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
        assert (this.watchCumul >= this.computeLeftSide());
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        long l;
        this.voc.watch(n, this);
        assert (this.watchCumul >= this.computeLeftSide()) : "" + this.watchCumul + "/" + this.computeLeftSide() + ":" + this.learnt;
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            l = this.coefs[n2];
        } else {
            l = this.litToCoeffs.get(n ^ 1);
        }
        long l2 = this.watchCumul - l;
        if (l2 < this.degree) {
            assert (!this.isSatisfiable());
            return false;
        }
        this.voc.undos(n).push(this);
        this.watchCumul = l2;
        long l3 = this.watchCumul - this.degree;
        for (int i = 0; i < this.coefs.length && l3 < this.coefs[i]; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            assert (!this.isSatisfiable());
            return false;
        }
        assert (this.learnt || this.watchCumul >= this.computeLeftSide());
        assert (this.watchCumul >= this.computeLeftSide());
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.voc.watches(this.lits[i] ^ 1).remove(this);
        }
    }

    public void undo(int n) {
        long l;
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            l = this.coefs[n2];
        } else {
            Long l2 = this.litToCoeffs.get(n ^ 1);
            l = l2 != null ? this.litToCoeffs.get(n ^ 1) : 0L;
        }
        this.watchCumul += l;
    }

    public static MaxWatchPbLongCP normalizedMaxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) throws ContradictionException {
        MaxWatchPbLongCP maxWatchPbLongCP = new MaxWatchPbLongCP(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
        if (maxWatchPbLongCP.degree <= 0L) {
            return null;
        }
        maxWatchPbLongCP.computeWatches();
        maxWatchPbLongCP.computePropagation(unitPropagationListener);
        return maxWatchPbLongCP;
    }

    public static WatchPbLongCP normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MaxWatchPbLongCP(iLits, iDataStructurePB);
    }
}

