/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MinWatchPb;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;

public final class PuebloMinWatchPb
extends MinWatchPb {
    private static final long serialVersionUID = 1L;

    private PuebloMinWatchPb(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        super(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
    }

    private PuebloMinWatchPb(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iLits, iDataStructurePB);
    }

    public static PuebloMinWatchPb normalizedMinWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        BigInteger bigInteger2 = BigInteger.ZERO;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            bigInteger2 = bigInteger2.add(bigInteger3);
        }
        PuebloMinWatchPb puebloMinWatchPb = new PuebloMinWatchPb(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
        if (puebloMinWatchPb.degree.signum() <= 0) {
            return null;
        }
        puebloMinWatchPb.computeWatches();
        puebloMinWatchPb.computePropagation(unitPropagationListener);
        return puebloMinWatchPb;
    }

    public static WatchPb normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new PuebloMinWatchPb(iLits, iDataStructurePB);
    }

    protected BigInteger maximalCoefficient(int n) {
        return this.coefs[0];
    }

    protected BigInteger updateWatched(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = bigInteger;
        if (this.watchingCount < this.size()) {
            BigInteger bigInteger3 = this.watchCumul.subtract(this.coefs[n]);
            BigInteger bigInteger4 = this.degree.add(bigInteger2);
            for (int i = 0; i < this.lits.length && bigInteger3.compareTo(bigInteger4) < 0; ++i) {
                if (this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                bigInteger3 = bigInteger3.add(this.coefs[i]);
                this.watched[i] = true;
                assert (this.watchingCount < this.size());
                this.watching[this.watchingCount++] = i;
                this.voc.watch(this.lits[i] ^ 1, this);
            }
            this.watchCumul = bigInteger3.add(this.coefs[n]);
        }
        return bigInteger2;
    }
}

