/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.reader;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.reader.JSONReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONPBReader
extends JSONReader<IPBSolver> {
    public static final String WLITERAL = "\\[(-?\\d+),(-?\\d+)\\]";
    public static final String WCLAUSE = "(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\])";
    public static final String PB = "(\\[(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\]),'[=<>]=?',-?\\d+\\])";
    public static final String OBJECTIVE_FUNCTION = "(\\[('min'|'max'),(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\])\\])";
    public static final Pattern PSEUDO_PATTERN = Pattern.compile("(\\[(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\]),'[=<>]=?',-?\\d+\\])");
    public static final Pattern WCLAUSE_PATTERN = Pattern.compile("(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\])");
    public static final Pattern WLITERAL_PATTERN = Pattern.compile("\\[(-?\\d+),(-?\\d+)\\]");
    public static final Pattern OBJECTIVE_FUNCTION_PATTERN = Pattern.compile("(\\[('min'|'max'),(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\])\\])");

    public JSONPBReader(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    @Override
    protected void handleNotHandled(String string) throws ParseFormatException, ContradictionException {
        if (PSEUDO_PATTERN.matcher(string).matches()) {
            this.handlePB(string);
        } else if (OBJECTIVE_FUNCTION_PATTERN.matcher(string).matches()) {
            this.handleObj(string);
        } else {
            throw new UnsupportedOperationException("Wrong formula " + string);
        }
    }

    private void handleObj(String string) {
        Matcher matcher = WCLAUSE_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group();
            string = matcher.replaceFirst("");
            matcher = WLITERAL_PATTERN.matcher(string2);
            VecInt vecInt = new VecInt();
            String[] stringArray = string.split(",");
            boolean bl = stringArray[0].contains("max");
            Vec<BigInteger> vec = new Vec<BigInteger>();
            while (matcher.find()) {
                vecInt.push(Integer.valueOf(matcher.group(2)));
                BigInteger bigInteger = new BigInteger(matcher.group(1));
                vec.push(bl ? bigInteger.negate() : bigInteger);
            }
            ((IPBSolver)this.solver).setObjectiveFunction(new ObjectiveFunction(vecInt, vec));
        }
    }

    private void handlePB(String string) throws ContradictionException {
        Matcher matcher = WCLAUSE_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group();
            string = matcher.replaceFirst("");
            matcher = WLITERAL_PATTERN.matcher(string2);
            VecInt vecInt = new VecInt();
            VecInt vecInt2 = new VecInt();
            while (matcher.find()) {
                vecInt.push(Integer.valueOf(matcher.group(2)));
                vecInt2.push(Integer.valueOf(matcher.group(1)));
            }
            String[] stringArray = string.split(",");
            String string3 = stringArray[1].substring(1, stringArray[1].length() - 1);
            int n = Integer.valueOf(stringArray[2].substring(0, stringArray[2].length() - 1));
            if ("=".equals(string3) || "==".equals(string3)) {
                ((IPBSolver)this.solver).addExactly((IVecInt)vecInt, vecInt2, n);
            } else if ("<=".equals(string3)) {
                ((IPBSolver)this.solver).addAtMost((IVecInt)vecInt, vecInt2, n);
            } else if ("<".equals(string3)) {
                ((IPBSolver)this.solver).addAtMost((IVecInt)vecInt, vecInt2, n - 1);
            } else if (">=".equals(string3)) {
                ((IPBSolver)this.solver).addAtLeast((IVecInt)vecInt, vecInt2, n);
            } else {
                assert (">".equals(string3));
                ((IPBSolver)this.solver).addAtLeast((IVecInt)vecInt, vecInt2, n + 1);
            }
        }
    }

    @Override
    protected String constraintRegexp() {
        return "((\\[(-?(\\d+)(,-?(\\d+))*)?\\])|(\\[(\\[(-?(\\d+)(,-?(\\d+))*)?\\]),'[=<>]=?',-?\\d+\\])|(\\[(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\]),'[=<>]=?',-?\\d+\\])|(\\[('min'|'max'),(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\])\\]))";
    }
}

