/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.Collection;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClauseSelectorSolver<T extends ISolver>
extends SolverDecorator<T> {
    private static final long serialVersionUID = 1L;
    private int lastCreatedVar;
    private boolean pooledVarId = false;
    private final SelectorState external = new SelectorState(){

        private IVecInt getNegatedSelectors() {
            VecInt vecInt = new VecInt();
            for (int n : AbstractClauseSelectorSolver.this.getAddedVars()) {
                vecInt.push(-n);
            }
            return vecInt;
        }

        public boolean isSatisfiable(boolean bl) throws TimeoutException {
            return AbstractClauseSelectorSolver.this.decorated().isSatisfiable(this.getNegatedSelectors(), bl);
        }

        public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
            IVecInt iVecInt2 = this.getNegatedSelectors();
            iVecInt.copyTo(iVecInt2);
            return AbstractClauseSelectorSolver.this.decorated().isSatisfiable(iVecInt2, bl);
        }

        public boolean isSatisfiable() throws TimeoutException {
            return AbstractClauseSelectorSolver.this.decorated().isSatisfiable(this.getNegatedSelectors());
        }

        public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
            IVecInt iVecInt2 = this.getNegatedSelectors();
            iVecInt.copyTo(iVecInt2);
            return AbstractClauseSelectorSolver.this.decorated().isSatisfiable(iVecInt2);
        }
    };
    private final SelectorState internal = new SelectorState(){

        public boolean isSatisfiable(boolean bl) throws TimeoutException {
            return AbstractClauseSelectorSolver.this.decorated().isSatisfiable(bl);
        }

        public boolean isSatisfiable() throws TimeoutException {
            return AbstractClauseSelectorSolver.this.decorated().isSatisfiable();
        }

        public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
            return AbstractClauseSelectorSolver.this.decorated().isSatisfiable(iVecInt);
        }

        public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
            return AbstractClauseSelectorSolver.this.decorated().isSatisfiable(iVecInt, bl);
        }
    };
    private SelectorState selectedState = this.external;

    public AbstractClauseSelectorSolver(T t) {
        super(t);
    }

    public abstract Collection<Integer> getAddedVars();

    protected int createNewVar(IVecInt iVecInt) {
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            if (Math.abs(iteratorInt.next()) <= this.nextFreeVarId(false)) continue;
            throw new IllegalStateException("Please call newVar(int) before adding constraints!!!");
        }
        if (this.pooledVarId) {
            this.pooledVarId = false;
            return this.lastCreatedVar;
        }
        this.lastCreatedVar = this.nextFreeVarId(true);
        return this.lastCreatedVar;
    }

    protected void discardLastestVar() {
        this.pooledVarId = true;
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.selectedState.isSatisfiable(bl);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        return this.selectedState.isSatisfiable(iVecInt, bl);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.selectedState.isSatisfiable();
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        return this.selectedState.isSatisfiable(iVecInt);
    }

    public void internalState() {
        this.selectedState = this.internal;
    }

    public void externalState() {
        this.selectedState = this.external;
    }

    private static interface SelectorState {
        public boolean isSatisfiable(boolean var1) throws TimeoutException;

        public boolean isSatisfiable() throws TimeoutException;

        public boolean isSatisfiable(IVecInt var1) throws TimeoutException;

        public boolean isSatisfiable(IVecInt var1, boolean var2) throws TimeoutException;
    }
}

