/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import org.sat4j.core.VecInt;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Evaluable;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class Var
implements Evaluable {
    private final Domain domain;
    private final String id;
    private final int startid;

    public Var(String string, Domain domain, int n) {
        this.domain = domain;
        this.id = string;
        this.startid = n + 1;
    }

    public Domain domain() {
        return this.domain;
    }

    public int translate(int n) {
        return this.domain.pos(n) + this.startid;
    }

    public void toClause(ISolver iSolver) throws ContradictionException {
        VecInt vecInt = new VecInt(this.domain.size());
        int n = 0;
        while (n < this.domain.size()) {
            vecInt.push(n + this.startid);
            ++n;
        }
        iSolver.addExactly((IVecInt)vecInt, 1);
    }

    public int findValue(int[] nArray) {
        int n = 0;
        while (n < this.domain.size()) {
            int n2 = n + this.startid;
            if (nArray[n2 - 1] == n2) {
                return this.domain.get(n);
            }
            ++n;
        }
        throw new IllegalStateException("BIG PROBLEM: no value for a var!");
    }

    public String toString() {
        return this.id;
    }
}

