/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.sat4j.core.Vec;
import org.sat4j.csp.Clausifiable;
import org.sat4j.csp.Constant;
import org.sat4j.csp.Domain;
import org.sat4j.csp.EnumeratedDomain;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Predicate;
import org.sat4j.csp.RangeDomain;
import org.sat4j.csp.Var;
import org.sat4j.csp.constraints.AllDiff;
import org.sat4j.csp.constraints.AllDiffCard;
import org.sat4j.csp.constraints.Nogoods;
import org.sat4j.csp.constraints.Relation;
import org.sat4j.csp.constraints.WalshSupports;
import org.sat4j.csp.xml.ICSPCallback;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

public class CSPReader
extends Reader
implements ICSPCallback {
    private final ISolver solver;
    protected Relation[] relations;
    private int valueindex;
    private int relindex;
    private int[] currentdomain;
    private Domain rangedomain;
    private String currentdomainid;
    private int currentdomainsize;
    private final Map<String, Domain> domainmapping = new HashMap<String, Domain>();
    private final Map<String, Var> varmapping = new LinkedHashMap<String, Var>();
    private final Map<String, Integer> relmapping = new HashMap<String, Integer>();
    private final Map<String, Clausifiable> predmapping = new HashMap<String, Clausifiable>();
    private int nbvarstocreate;
    private int tupleindex;
    private Clausifiable currentclausifiable;
    private Predicate currentpredicate;
    private final IVec<Evaluable> variables = new Vec();
    private final IVec<Var> scope = new Vec();
    private int nbvars;
    private int nbconstraints;
    private int currentconstraint;

    public CSPReader(ISolver iSolver, boolean bl) {
        this.solver = iSolver;
        AllDiff allDiff = bl ? new AllDiffCard() : new AllDiff();
        this.predmapping.put("global:allDifferent", allDiff);
        this.predmapping.put("global:alldifferent", allDiff);
        if (iSolver.isVerbose()) {
            System.out.println("c " + allDiff);
        }
    }

    public final IProblem parseInstance(java.io.Reader reader) throws ParseFormatException, ContradictionException, IOException {
        return this.parseInstance(new LineNumberReader(reader));
    }

    private IProblem parseInstance(LineNumberReader lineNumberReader) throws ParseFormatException {
        this.solver.reset();
        try {
            this.readProblem(lineNumberReader);
            return this.solver;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseFormatException("integer value expected on line " + lineNumberReader.getLineNumber(), (Throwable)numberFormatException);
        }
    }

    public void decode(int[] nArray, PrintWriter printWriter) {
        for (Var var : this.varmapping.values()) {
            printWriter.print(var.findValue(nArray));
            printWriter.print(" ");
        }
    }

    public String decode(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Var var : this.varmapping.values()) {
            stringBuilder.append(var.findValue(nArray));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private void readProblem(LineNumberReader lineNumberReader) {
        int n;
        int n2;
        int n3;
        int n4;
        Scanner scanner = new Scanner(lineNumberReader);
        this.beginInstance(scanner.nextLine());
        int n5 = scanner.nextInt();
        this.beginDomainsSection(n5);
        int n6 = 0;
        while (n6 < n5) {
            n4 = scanner.nextInt();
            assert (n4 == n6);
            int[] nArray = this.readArrayOfInt(scanner);
            this.beginDomain("" + n4, nArray.length);
            n3 = 0;
            while (n3 < nArray.length) {
                this.addDomainValue(nArray[n3]);
                ++n3;
            }
            this.endDomain();
            ++n6;
        }
        this.endDomainsSection();
        n6 = scanner.nextInt();
        this.beginVariablesSection(n6);
        n4 = 0;
        while (n4 < n6) {
            int n7 = scanner.nextInt();
            assert (n7 == n4);
            n3 = scanner.nextInt();
            this.addVariable("" + n7, "" + n3);
            ++n4;
        }
        this.endVariablesSection();
        n4 = scanner.nextInt();
        this.beginRelationsSection(n4);
        int n8 = 0;
        while (n8 < n4) {
            n3 = scanner.nextInt();
            assert (n3 == n8);
            boolean bl = scanner.nextInt() != 1;
            int[] nArray = this.readArrayOfInt(scanner);
            n2 = scanner.nextInt();
            this.beginRelation("" + n3, nArray.length, n2, !bl);
            n = 0;
            while (n < n2) {
                int[] nArray2 = this.readArrayOfInt(scanner, this.relations[n3].arity());
                this.addRelationTuple(nArray2);
                ++n;
            }
            this.endRelation();
            ++n8;
        }
        this.endRelationsSection();
        n8 = scanner.nextInt();
        this.beginConstraintsSection(n8);
        n3 = 0;
        while (n3 < n8) {
            int[] nArray = this.readArrayOfInt(scanner);
            this.beginConstraint("" + n3, nArray.length);
            int n9 = scanner.nextInt();
            this.constraintReference("" + n9);
            int[] nArray3 = nArray;
            int n10 = nArray.length;
            n = 0;
            while (n < n10) {
                n2 = nArray3[n];
                this.addEffectiveParameter("" + n2);
                ++n;
            }
            this.endConstraint();
            ++n3;
        }
        this.endConstraintsSection();
        this.endInstance();
    }

    protected void manageAllowedTuples(int n, int n2, int n3) {
        this.relations[n] = new WalshSupports(n2, n3);
    }

    private int[] readArrayOfInt(Scanner scanner) {
        int n = scanner.nextInt();
        return this.readArrayOfInt(scanner, n);
    }

    private int[] readArrayOfInt(Scanner scanner, int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = scanner.nextInt();
            ++n2;
        }
        return nArray;
    }

    public void beginInstance(String string) {
        System.out.println("c reading problem named " + string);
    }

    public void beginDomainsSection(int n) {
        System.out.print("c reading domains");
    }

    public void beginDomain(String string, int n) {
        this.currentdomainsize = n;
        this.currentdomain = null;
        this.valueindex = -1;
        this.currentdomainid = string;
        this.rangedomain = null;
    }

    public void addDomainValue(int n) {
        if (this.currentdomain == null) {
            this.currentdomain = new int[this.currentdomainsize];
        }
        if (this.rangedomain != null) {
            int n2 = 0;
            while (n2 < this.rangedomain.size()) {
                this.currentdomain[++this.valueindex] = this.rangedomain.get(n2);
                ++n2;
            }
            this.rangedomain = null;
        }
        this.currentdomain[++this.valueindex] = n;
    }

    public void addDomainValue(int n, int n2) {
        if (this.currentdomainsize == n2 - n + 1) {
            this.rangedomain = new RangeDomain(n, n2);
        } else {
            if (this.currentdomain == null) {
                this.currentdomain = new int[this.currentdomainsize];
            }
            int n3 = n;
            while (n3 <= n2) {
                this.currentdomain[++this.valueindex] = n3++;
            }
        }
    }

    public void endDomain() {
        assert (this.rangedomain != null || this.valueindex == this.currentdomain.length - 1);
        if (this.rangedomain == null) {
            this.domainmapping.put(this.currentdomainid, new EnumeratedDomain(this.currentdomain));
        } else {
            this.domainmapping.put(this.currentdomainid, this.rangedomain);
        }
    }

    public void endDomainsSection() {
        System.out.println(" done.");
    }

    public void beginVariablesSection(int n) {
        System.out.print("c reading variables");
        this.nbvarstocreate = 0;
        this.nbvars = n;
    }

    public void addVariable(String string, String string2) {
        Domain domain = this.domainmapping.get(string2);
        this.varmapping.put(string, new Var(string, domain, this.nbvarstocreate));
        this.nbvarstocreate += domain.size();
        if (this.isVerbose()) {
            System.out.print("\rc reading variables " + this.varmapping.size() + "/" + this.nbvars);
        }
    }

    public void endVariablesSection() {
        block5: {
            if (this.isVerbose()) {
                System.out.println("\rc reading variables (" + this.nbvars + ") done.");
            } else {
                System.out.println(" done.");
            }
            this.solver.newVar(this.nbvarstocreate);
            try {
                for (Evaluable evaluable : this.varmapping.values()) {
                    evaluable.toClause(this.solver);
                }
            }
            catch (ContradictionException contradictionException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    public void beginRelationsSection(int n) {
        System.out.print("c reading relations");
        this.relations = new Relation[n];
        this.relindex = -1;
    }

    public void beginRelation(String string, int n, int n2, boolean bl) {
        this.relmapping.put(string, ++this.relindex);
        if (this.isVerbose()) {
            System.out.print("\rc reading relations " + this.relindex + "/" + this.relations.length);
        }
        if (bl) {
            this.manageAllowedTuples(this.relindex, n, n2);
        } else {
            this.relations[this.relindex] = new Nogoods(n, n2);
        }
        this.tupleindex = -1;
    }

    public void addRelationTuple(int[] nArray) {
        this.relations[this.relindex].addTuple(++this.tupleindex, nArray);
    }

    public void endRelation() {
    }

    public void endRelationsSection() {
        if (this.isVerbose()) {
            System.out.println("\rc reading relations (" + this.relations.length + ") done.");
        } else {
            System.out.println(" done.");
        }
    }

    public void beginPredicatesSection(int n) {
        System.out.print("c reading predicates ");
    }

    public void beginPredicate(String string) {
        this.currentpredicate = new Predicate();
        this.predmapping.put(string, this.currentpredicate);
        if (this.isVerbose()) {
            System.out.print("\rc reading predicate " + this.predmapping.size());
        }
    }

    public void addFormalParameter(String string, String string2) {
        this.currentpredicate.addVariable(string);
    }

    public void predicateExpression(String string) {
        this.currentpredicate.setExpression(string);
    }

    public void endPredicate() {
    }

    public void endPredicatesSection() {
        if (this.isVerbose()) {
            System.out.println("\rc reading relations (" + this.predmapping.size() + ") done.");
        } else {
            System.out.println(" done.");
        }
    }

    public void beginConstraintsSection(int n) {
        System.out.println("c reading constraints");
        this.nbconstraints = n;
        this.currentconstraint = 0;
    }

    public void beginConstraint(String string, int n) {
        this.variables.clear();
        this.variables.ensure(n);
        this.scope.clear();
        this.scope.ensure(n);
        if (this.isVerbose()) {
            System.out.print("\rc grounding constraint " + string + "(" + ++this.currentconstraint * 100 / this.nbconstraints + "%)");
        }
    }

    public void constraintReference(String string) {
        Integer n = this.relmapping.get(string);
        this.currentclausifiable = n == null ? this.predmapping.get(string) : this.relations[n];
        if (this.currentclausifiable == null) {
            throw new IllegalArgumentException("Reference not supported:  " + string);
        }
    }

    public void addVariableToConstraint(String string) {
        this.scope.push((Object)this.varmapping.get(string));
    }

    public void addEffectiveParameter(String string) {
        this.variables.push((Object)this.varmapping.get(string));
    }

    public void addEffectiveParameter(int n) {
        this.variables.push((Object)new Constant(n));
    }

    public void beginParameterList() {
        throw new UnsupportedOperationException("I do not handle parameter list yet!");
    }

    public void addIntegerItem(int n) {
    }

    public void addVariableItem(String string) {
    }

    public void endParamaterList() {
    }

    public void addConstantParameter(String string, int n) {
        throw new UnsupportedOperationException("I do not handle constant parameter yet!");
    }

    public void constraintExpression(String string) {
        throw new UnsupportedOperationException("I do not handle constraint expression yet!");
    }

    public void endConstraint() {
        try {
            this.currentclausifiable.toClause(this.solver, this.scope, this.variables);
        }
        catch (ContradictionException contradictionException) {
            System.err.println("c INSTANCE TRIVIALLY UNSAT");
            throw new IllegalStateException(contradictionException);
        }
    }

    public void endConstraintsSection() {
        if (this.isVerbose()) {
            System.out.println("\rc reading constraints done.");
        } else {
            System.out.println("c done with constraints.");
        }
    }

    public void endInstance() {
    }

    IProblem getProblem() {
        return this.solver;
    }

    public IProblem parseInstance(InputStream inputStream) throws ParseFormatException, ContradictionException, IOException {
        return this.parseInstance(new InputStreamReader(inputStream));
    }
}

