/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.GroupedCNFReader;
import org.sat4j.reader.LecteurDimacs;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.AbstractClauseSelectorSolver;
import org.sat4j.tools.AllMUSes;
import org.sat4j.tools.SolutionFoundListener;
import org.sat4j.tools.xplain.Explainer;
import org.sat4j.tools.xplain.HighLevelXplain;
import org.sat4j.tools.xplain.MinimizationStrategy;
import org.sat4j.tools.xplain.Xplain;

public class MUSLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    private int[] mus;
    private Explainer xplain;
    private boolean highLevel = false;
    private AllMUSes allMuses;
    private int muscount = 0;

    public void usage() {
        this.log("java -jar sat4j-mus.jar [Insertion|Deletion|QuickXplain] <cnffile>|<gcnffile>");
    }

    protected Reader createReader(ISolver iSolver, String string) {
        if (this.highLevel) {
            return new GroupedCNFReader((HighLevelXplain)iSolver);
        }
        return new LecteurDimacs(iSolver);
    }

    protected String getInstanceName(String[] stringArray) {
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[stringArray.length - 1];
    }

    protected ISolver configureSolver(String[] stringArray) {
        AbstractClauseSelectorSolver abstractClauseSelectorSolver;
        Object object;
        String string = stringArray[stringArray.length - 1];
        if (string.endsWith(".gcnf")) {
            this.highLevel = true;
        }
        if (this.highLevel) {
            object = new HighLevelXplain<ISolver>(SolverFactory.newDefault());
            this.xplain = object;
            abstractClauseSelectorSolver = object;
        } else {
            object = new Xplain<ISolver>(SolverFactory.newDefault(), false);
            this.xplain = object;
            abstractClauseSelectorSolver = object;
        }
        abstractClauseSelectorSolver.setDBSimplificationAllowed(true);
        if (stringArray.length == 2) {
            if ("all".equals(stringArray[0])) {
                this.allMuses = new AllMUSes(this.highLevel, SolverFactory.instance());
                abstractClauseSelectorSolver = this.allMuses.getSolverInstance();
            } else {
                object = "org.sat4j.tools.xplain." + stringArray[0] + "Strategy";
                try {
                    this.xplain.setMinimizationStrategy((MinimizationStrategy)Class.forName((String)object).newInstance());
                }
                catch (Exception exception) {
                    this.log(exception.getMessage());
                }
            }
        }
        abstractClauseSelectorSolver.setTimeout(Integer.MAX_VALUE);
        this.getLogWriter().println(abstractClauseSelectorSolver.toString("c "));
        return abstractClauseSelectorSolver;
    }

    protected void displayResult() {
        if (this.solver != null) {
            double d = (double)(System.currentTimeMillis() - this.beginTime) / 1000.0;
            this.solver.printStat(this.out);
            this.solver.printInfos(this.out);
            this.out.println("s " + this.exitCode);
            if (this.exitCode == ExitCode.SATISFIABLE) {
                int[] nArray = this.solver.model();
                this.out.print("v ");
                this.reader.decode(nArray, this.out);
                this.out.println();
            } else if (this.exitCode == ExitCode.UNSATISFIABLE && this.mus != null) {
                this.out.print("v ");
                this.reader.decode(this.mus, this.out);
                this.out.println();
            }
            this.log("Total wall clock time (in seconds) : " + d);
        }
    }

    public void run(String[] stringArray) {
        this.mus = null;
        super.run(stringArray);
        double d = (double)(System.currentTimeMillis() - this.beginTime) / 1000.0;
        if (this.exitCode == ExitCode.UNSATISFIABLE) {
            try {
                this.log("Unsat detection wall clock time (in seconds) : " + d);
                double d2 = System.currentTimeMillis();
                if (this.allMuses != null) {
                    SolutionFoundListener solutionFoundListener = new SolutionFoundListener(){
                        private int msscount = 0;

                        public void onUnsatTermination() {
                            throw new UnsupportedOperationException("Not implemented yet!");
                        }

                        public void onSolutionFound(IVecInt iVecInt) {
                            System.out.print("\r" + MUSLauncher.this.solver.getLogPrefix() + "found mss number " + ++this.msscount);
                        }

                        public void onSolutionFound(int[] nArray) {
                            throw new UnsupportedOperationException("Not implemented yet!");
                        }
                    };
                    SolutionFoundListener solutionFoundListener2 = new SolutionFoundListener(){

                        public void onSolutionFound(int[] nArray) {
                        }

                        public void onSolutionFound(IVecInt iVecInt) {
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(MUSLauncher.this.solver.getLogPrefix())).append("found mus number ");
                            MUSLauncher mUSLauncher = MUSLauncher.this;
                            int n = mUSLauncher.muscount + 1;
                            mUSLauncher.muscount = n;
                            System.out.println(stringBuilder.append(n).toString());
                            MUSLauncher.this.out.print("v ");
                            int[] nArray = new int[iVecInt.size()];
                            iVecInt.copyTo(nArray);
                            MUSLauncher.this.reader.decode(nArray, MUSLauncher.this.out);
                            MUSLauncher.this.out.println();
                        }

                        public void onUnsatTermination() {
                        }
                    };
                    this.allMuses.computeAllMSS(solutionFoundListener);
                    if ("card".equals(System.getProperty("min"))) {
                        this.allMuses.computeAllMUSesOrdered(solutionFoundListener2);
                    } else {
                        this.allMuses.computeAllMUSes(solutionFoundListener2);
                    }
                    this.log("All MUSes computation wall clock time (in seconds) : " + ((double)System.currentTimeMillis() - d2) / 1000.0);
                } else {
                    this.log("Size of initial " + (this.highLevel ? "high level " : "") + "unsat subformula: " + this.solver.unsatExplanation().size());
                    this.log("Computing " + (this.highLevel ? "high level " : "") + "MUS ...");
                    this.mus = this.xplain.minimalExplanation();
                    this.log("Size of the " + (this.highLevel ? "high level " : "") + "MUS: " + this.mus.length);
                    this.log("Unsat core  computation wall clock time (in seconds) : " + ((double)System.currentTimeMillis() - d2) / 1000.0);
                }
            }
            catch (TimeoutException timeoutException) {
                this.log("Cannot compute " + (this.highLevel ? "high level " : "") + "MUS within the timeout.");
            }
        }
    }

    public static void main(String[] stringArray) {
        MUSLauncher mUSLauncher = new MUSLauncher();
        if (stringArray.length < 1 || stringArray.length > 2) {
            mUSLauncher.usage();
            return;
        }
        mUSLauncher.run(stringArray);
        System.exit(mUSLauncher.getExitCode().value());
    }
}

