/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.PrintWriter;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;

public class OptToPBSATAdapter
extends PBSolverDecorator {
    private static final long serialVersionUID = 1L;
    IOptimizationProblem problem;
    private final IVecInt assumps = new VecInt();
    private long begin;
    private SolutionFoundListener sfl;

    public OptToPBSATAdapter(IOptimizationProblem iOptimizationProblem) {
        this(iOptimizationProblem, SolutionFoundListener.VOID);
    }

    public OptToPBSATAdapter(IOptimizationProblem iOptimizationProblem, SolutionFoundListener solutionFoundListener) {
        super((IPBSolver)((Object)iOptimizationProblem));
        this.problem = iOptimizationProblem;
        this.sfl = solutionFoundListener;
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.isSatisfiable();
    }

    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        return this.isSatisfiable(iVecInt);
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        this.assumps.clear();
        iVecInt.copyTo(this.assumps);
        this.begin = System.currentTimeMillis();
        if (this.problem.hasNoObjectiveFunction()) {
            return this.problem.isSatisfiable(iVecInt);
        }
        boolean bl = false;
        try {
            while (this.problem.admitABetterSolution(iVecInt)) {
                bl = true;
                this.sfl.onSolutionFound(this.problem.model());
                this.problem.discardCurrentSolution();
                if (!this.isVerbose()) continue;
                System.out.println(String.valueOf(this.getLogPrefix()) + "Current objective function value: " + this.problem.getObjectiveValue() + "(" + (double)(System.currentTimeMillis() - this.begin) / 1000.0 + "s)");
            }
            this.sfl.onUnsatTermination();
        }
        catch (ContradictionException contradictionException) {
            this.sfl.onUnsatTermination();
        }
        return bl;
    }

    public int[] model() {
        return this.model(new PrintWriter(System.out, true));
    }

    public int[] model(PrintWriter printWriter) {
        return this.problem.model();
    }

    public boolean model(int n) {
        return this.problem.model(n);
    }

    public String toString(String string) {
        return String.valueOf(string) + "Optimization to Pseudo Boolean adapter\n" + super.toString(string);
    }

    public boolean isOptimal() {
        return this.problem.isOptimal();
    }

    public Number getCurrentObjectiveValue() {
        return this.problem.getObjectiveValue();
    }

    public void setTimeoutForFindingBetterSolution(int n) {
        this.problem.setTimeoutForFindingBetterSolution(n);
    }

    public void setSolutionFoundListener(SolutionFoundListener solutionFoundListener) {
        this.sfl = solutionFoundListener;
    }
}

