/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Clauses;
import org.sat4j.minisat.core.Constr;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.ICardConstructor;
import org.sat4j.pb.constraints.IClauseConstructor;
import org.sat4j.pb.constraints.IPBConstructor;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.Pseudos;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPBClauseCardConstrDataStructure
extends AbstractPBDataStructureFactory {
    private static final long serialVersionUID = 1L;
    static final BigInteger MAX_INT_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    private final IPBConstructor ipbc;
    private final ICardConstructor icardc;
    private final IClauseConstructor iclausec;

    AbstractPBClauseCardConstrDataStructure(IClauseConstructor iClauseConstructor, ICardConstructor iCardConstructor, IPBConstructor iPBConstructor) {
        this.iclausec = iClauseConstructor;
        this.icardc = iCardConstructor;
        this.ipbc = iPBConstructor;
    }

    @Override
    public Constr createClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = Clauses.sanityCheck(iVecInt, this.getVocabulary(), this.solver);
        return this.constructClause(iVecInt2);
    }

    @Override
    public Constr createUnregisteredClause(IVecInt iVecInt) {
        return this.constructLearntClause(iVecInt);
    }

    @Override
    protected Constr constraintFactory(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        if (nArray.length == 0 && bigInteger.signum() <= 0) {
            return null;
        }
        if (bigInteger.equals(BigInteger.ONE)) {
            IVecInt iVecInt = Clauses.sanityCheck(new VecInt(nArray), this.getVocabulary(), this.solver);
            if (iVecInt == null) {
                return null;
            }
            return this.constructClause(iVecInt);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(bigIntegerArray)) {
            assert (bigInteger.compareTo(MAX_INT_VALUE) < 0);
            return this.constructCard(new VecInt(nArray), bigInteger.intValue());
        }
        return this.constructPB(nArray, bigIntegerArray, bigInteger);
    }

    @Override
    protected Constr learntConstraintFactory(IDataStructurePB iDataStructurePB) {
        if (iDataStructurePB.getDegree().equals(BigInteger.ONE)) {
            VecInt vecInt = new VecInt();
            Vec<BigInteger> vec = new Vec<BigInteger>();
            iDataStructurePB.buildConstraintFromConflict(vecInt, vec);
            int n = iDataStructurePB.getAssertiveLiteral();
            if (n > -1) {
                int n2 = vecInt.get(n);
                vecInt.set(n, vecInt.get(0));
                vecInt.set(0, n2);
            }
            return this.constructLearntClause(vecInt);
        }
        if (iDataStructurePB.isCardinality()) {
            return this.constructLearntCard(iDataStructurePB);
        }
        return this.constructLearntPB(iDataStructurePB);
    }

    private Constr learntConstraintFactory(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger, boolean bl) {
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        BigInteger[] bigIntegerArray = new BigInteger[iVec.size()];
        iVec.copyTo(bigIntegerArray);
        bigInteger = Pseudos.niceCheckedParametersForCompetition(nArray, bigIntegerArray, bl, bigInteger);
        if (bigInteger.equals(BigInteger.ONE)) {
            return this.constructLearntClause(new VecInt(nArray));
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(bigIntegerArray)) {
            return this.constructLearntCard(new VecInt(nArray), new Vec<BigInteger>(bigIntegerArray), bigInteger);
        }
        return this.constructLearntPB(new VecInt(nArray), new Vec<BigInteger>(bigIntegerArray), bigInteger);
    }

    @Override
    protected Constr learntAtLeastConstraintFactory(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        return this.learntConstraintFactory(iVecInt, iVec, bigInteger, true);
    }

    @Override
    protected Constr learntAtMostConstraintFactory(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        return this.learntConstraintFactory(iVecInt, iVec, bigInteger, false);
    }

    static boolean coefficientsEqualToOne(BigInteger[] bigIntegerArray) {
        int n = 0;
        while (n < bigIntegerArray.length) {
            if (!bigIntegerArray[n].equals(BigInteger.ONE)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected Constr constructClause(IVecInt iVecInt) {
        return this.iclausec.constructClause(this.solver, this.getVocabulary(), iVecInt);
    }

    protected Constr constructCard(IVecInt iVecInt, int n) throws ContradictionException {
        return this.icardc.constructCard(this.solver, this.getVocabulary(), iVecInt, n);
    }

    protected Constr constructPB(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        return this.ipbc.constructPB(this.solver, this.getVocabulary(), nArray, bigIntegerArray, bigInteger, AbstractPBClauseCardConstrDataStructure.sumOfCoefficients(bigIntegerArray));
    }

    protected Constr constructLearntClause(IVecInt iVecInt) {
        return this.iclausec.constructLearntClause(this.getVocabulary(), iVecInt);
    }

    protected Constr constructLearntCard(IDataStructurePB iDataStructurePB) {
        return this.icardc.constructLearntCard(this.getVocabulary(), iDataStructurePB);
    }

    protected Constr constructLearntCard(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        return this.icardc.constructLearntCard(this.getVocabulary(), new MapPb(iVecInt, iVec, bigInteger));
    }

    protected Constr constructLearntPB(IDataStructurePB iDataStructurePB) {
        return this.ipbc.constructLearntPB(this.getVocabulary(), iDataStructurePB);
    }

    protected Constr constructLearntPB(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        return this.ipbc.constructLearntPB(this.getVocabulary(), new MapPb(iVecInt, iVec, bigInteger));
    }

    public static final BigInteger sumOfCoefficients(BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger[] bigIntegerArray2 = bigIntegerArray;
        int n = bigIntegerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BigInteger bigInteger2 = bigIntegerArray2[n2];
            bigInteger = bigInteger.add(bigInteger2);
            ++n2;
        }
        return bigInteger;
    }
}

