/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.orders;

import java.math.BigInteger;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.orders.PhaseInLastLearnedClauseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.orders.IOrderObjective;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class VarOrderHeapObjective
extends VarOrderHeap
implements IOrderObjective {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction obj;

    public VarOrderHeapObjective() {
        this(new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public VarOrderHeapObjective(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        super(iPhaseSelectionStrategy);
    }

    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.obj = objectiveFunction;
    }

    public void init() {
        super.init();
        if (this.obj != null) {
            IVecInt iVecInt = this.obj.getVars();
            IVec<BigInteger> iVec = this.obj.getCoeffs();
            int n = 0;
            while (n < iVecInt.size()) {
                int n2 = iVecInt.get(n);
                if (this.lits.belongsToPool(Math.abs(n2))) {
                    int n3 = this.lits.getFromPool(n2);
                    BigInteger bigInteger = iVec.get(n);
                    if (bigInteger.signum() < 0) {
                        n3 = LiteralsUtils.neg(n3);
                    }
                    int n4 = LiteralsUtils.var(n3);
                    this.activity[n4] = bigInteger.bitLength() < 64 ? bigInteger.abs().longValue() : Long.MAX_VALUE;
                    if (this.heap.inHeap(n4)) {
                        this.heap.increase(n4);
                    } else {
                        this.heap.insert(n4);
                    }
                    this.phaseStrategy.init(n4, LiteralsUtils.neg(n3));
                }
                ++n;
            }
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " taking into account the objective function";
    }
}

