/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Collection;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.LexicoDecoratorPB;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLexicoHelper<T, C>
extends DependencyHelper<T, C>
implements SolutionFoundListener {
    private final LexicoDecoratorPB lexico;
    private boolean hasASolution;

    public AbstractLexicoHelper(LexicoDecoratorPB lexicoDecoratorPB) {
        super(new OptToPBSATAdapter(lexicoDecoratorPB));
        this.lexico = lexicoDecoratorPB;
        ((OptToPBSATAdapter)this.getSolver()).setSolutionFoundListener(this);
    }

    public AbstractLexicoHelper(LexicoDecoratorPB lexicoDecoratorPB, boolean bl) {
        super(new OptToPBSATAdapter(lexicoDecoratorPB), bl);
        this.lexico = lexicoDecoratorPB;
        ((OptToPBSATAdapter)this.getSolver()).setSolutionFoundListener(this);
    }

    public AbstractLexicoHelper(LexicoDecoratorPB lexicoDecoratorPB, boolean bl, boolean bl2) {
        super(new OptToPBSATAdapter(lexicoDecoratorPB), bl, bl2);
        this.lexico = lexicoDecoratorPB;
        ((OptToPBSATAdapter)this.getSolver()).setSolutionFoundListener(this);
    }

    public void addCriterion(Collection<T> collection) {
        VecInt vecInt = new VecInt(collection.size());
        for (T t : collection) {
            vecInt.push(this.getIntValue(t));
        }
        this.lexico.addCriterion(vecInt);
    }

    public void addWeightedCriterion(Collection<WeightedObject<T>> collection) {
        VecInt vecInt = new VecInt(collection.size());
        Vec<BigInteger> vec = new Vec<BigInteger>(collection.size());
        for (WeightedObject<T> weightedObject : collection) {
            vecInt.push(this.getIntValue(weightedObject.thing));
            vec.push(weightedObject.getWeight());
        }
        this.lexico.addCriterion(vecInt, vec);
    }

    @Override
    public boolean hasASolution() throws TimeoutException {
        try {
            return super.hasASolution();
        }
        catch (TimeoutException timeoutException) {
            if (this.hasASolution) {
                return true;
            }
            throw timeoutException;
        }
    }

    @Override
    public boolean hasASolution(IVec<T> iVec) throws TimeoutException {
        try {
            return super.hasASolution(iVec);
        }
        catch (TimeoutException timeoutException) {
            if (this.hasASolution) {
                return true;
            }
            throw timeoutException;
        }
    }

    @Override
    public boolean hasASolution(Collection<T> collection) throws TimeoutException {
        try {
            return super.hasASolution(collection);
        }
        catch (TimeoutException timeoutException) {
            if (this.hasASolution) {
                return true;
            }
            throw timeoutException;
        }
    }

    public boolean isOptimal() {
        return ((OptToPBSATAdapter)this.getSolver()).isOptimal();
    }

    @Override
    public void onSolutionFound(int[] nArray) {
        this.hasASolution = true;
    }

    @Override
    public void onSolutionFound(IVecInt iVecInt) {
        this.hasASolution = true;
    }

    @Override
    public void onUnsatTermination() {
    }
}

