/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Locale;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.CSPReader;
import org.sat4j.reader.CSPSupportReader;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.reader.XMLCSPReader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class CSPInstanceReader
extends InstanceReader {
    private CSPReader csp;
    private CSPReader csp2;
    private CSPReader csp3;
    private XMLCSPReader xmlcsp;
    private Reader reader = null;
    private final ISolver solver;
    private boolean allDiffCard;

    public CSPInstanceReader(ISolver iSolver, boolean bl) {
        super(iSolver);
        this.solver = iSolver;
        this.allDiffCard = bl;
    }

    private Reader getCSPReader1() {
        if (this.csp == null) {
            this.csp = new CSPReader(this.solver, this.allDiffCard);
        }
        return this.csp;
    }

    private Reader getCSPReader2() {
        if (this.csp2 == null) {
            this.csp2 = new CSPSupportReader(this.solver, this.allDiffCard);
        }
        return this.csp2;
    }

    private Reader getCSPReader3() {
        if (this.csp3 == null) {
            this.csp3 = new CSPExtSupportReader(this.solver, this.allDiffCard);
        }
        return this.csp3;
    }

    private Reader getXMLCSPReader() {
        if (this.xmlcsp == null) {
            this.xmlcsp = new XMLCSPReader(this.solver, this.allDiffCard);
        }
        return this.xmlcsp;
    }

    public IProblem parseInstance(String string) throws ParseFormatException, IOException, ContradictionException {
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        if (string.startsWith("http://")) {
            bl = true;
            string2 = string;
            string = string.substring(string.lastIndexOf(47), string.length() - 1);
        }
        if (string.indexOf(58) != -1) {
            String[] stringArray = string.split(":");
            string = stringArray[1];
            string3 = stringArray[0].toUpperCase(Locale.getDefault());
        }
        String string4 = string.endsWith(".gz") ? string.substring(0, string.lastIndexOf(46)) : string;
        if ("CSP".equals(string3)) {
            this.reader = this.getCSPReader1();
        } else if ("CSP3".equals(string3)) {
            this.reader = this.getCSPReader3();
        } else if (string4.endsWith(".txt") || "CSP2".equals(string3)) {
            this.reader = this.getCSPReader2();
        }
        if (!string4.endsWith(".xml")) {
            return super.parseInstance(string);
        }
        this.reader = this.getXMLCSPReader();
        if (bl) {
            return this.reader.parseInstance(new URL(string2).openStream());
        }
        return this.reader.parseInstance(string);
    }

    @Deprecated
    public String decode(int[] nArray) {
        return this.reader.decode(nArray);
    }

    public void decode(int[] nArray, PrintWriter printWriter) {
        this.reader.decode(nArray, printWriter);
    }

    public IProblem parseInstance(java.io.Reader reader) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException();
    }
}

