/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptToSatAdapter
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;
    IOptimizationProblem problem;
    boolean optimalValueForced = false;
    private final IVecInt assumps = new VecInt();
    private long begin;
    private final SolutionFoundListener sfl;

    public OptToSatAdapter(IOptimizationProblem iOptimizationProblem) {
        this(iOptimizationProblem, SolutionFoundListener.VOID);
    }

    public OptToSatAdapter(IOptimizationProblem iOptimizationProblem, SolutionFoundListener solutionFoundListener) {
        super((ISolver)((Object)iOptimizationProblem));
        this.problem = iOptimizationProblem;
        this.sfl = solutionFoundListener;
    }

    @Override
    public void reset() {
        super.reset();
        this.optimalValueForced = false;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.isSatisfiable();
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        return this.isSatisfiable(iVecInt);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        this.assumps.clear();
        iVecInt.copyTo(this.assumps);
        this.begin = System.currentTimeMillis();
        if (this.problem.hasNoObjectiveFunction()) {
            return this.problem.isSatisfiable(iVecInt);
        }
        boolean bl = false;
        try {
            while (this.problem.admitABetterSolution(iVecInt)) {
                bl = true;
                this.sfl.onSolutionFound(this.problem.model());
                this.problem.discardCurrentSolution();
                if (!this.isVerbose()) continue;
                System.out.println(String.valueOf(this.getLogPrefix()) + "Current objective function value: " + this.problem.getObjectiveValue() + "(" + (double)(System.currentTimeMillis() - this.begin) / 1000.0 + "s)");
            }
            this.sfl.onUnsatTermination();
        }
        catch (ContradictionException contradictionException) {
            this.sfl.onUnsatTermination();
        }
        return bl;
    }

    @Override
    public int[] model() {
        return this.problem.model();
    }

    @Override
    public boolean model(int n) {
        return this.problem.model(n);
    }

    @Override
    public int[] modelWithInternalVariables() {
        return this.decorated().modelWithInternalVariables();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        if (this.isSatisfiable(iVecInt)) {
            return this.model();
        }
        return null;
    }

    @Override
    public String toString(String string) {
        return String.valueOf(string) + "Optimization to SAT adapter\n" + super.toString(string);
    }

    public boolean isOptimal() {
        return this.problem.isOptimal();
    }
}

