/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Counter;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.specs.UnitClauseProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsSolver
implements ISolver {
    private static final String NOT_IMPLEMENTED_YET = "Not implemented yet!";
    private static final String THAT_SOLVER_ONLY_COMPUTE_STATISTICS = "That solver only compute statistics";
    private static final long serialVersionUID = 1L;
    private int expectedNumberOfConstraints;
    private int nbvars;
    private IVecInt[] sizeoccurrences;
    private int allpositive;
    private int allnegative;
    private int horn;
    private int dualhorn;
    private final Map<Integer, Counter> sizes = new HashMap<Integer, Counter>();

    @Override
    public int[] model() {
        throw new UnsupportedOperationException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean model(int n) {
        throw new UnsupportedOperationException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public int[] primeImplicant() {
        throw new UnsupportedOperationException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean primeImplicant(int n) {
        throw new UnsupportedOperationException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public int[] findModel() throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public int nConstraints() {
        return this.expectedNumberOfConstraints;
    }

    @Override
    public int newVar(int n) {
        this.nbvars = n;
        this.sizeoccurrences = new IVecInt[n + 1 << 1];
        return n;
    }

    @Override
    public int nVars() {
        return this.nbvars;
    }

    @Override
    @Deprecated
    public void printInfos(PrintWriter printWriter, String string) {
    }

    @Override
    public void printInfos(PrintWriter printWriter) {
    }

    @Override
    @Deprecated
    public int newVar() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public int nextFreeVarId(boolean bl) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void registerLiteral(int n) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.expectedNumberOfConstraints = n;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        int n = iVecInt.size();
        Counter counter = this.sizes.get(n);
        if (counter == null) {
            counter = new Counter(0);
            this.sizes.put(n, counter);
        }
        counter.inc();
        int n2 = 0;
        int n3 = 0;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n4 = iteratorInt.next();
            if (n4 > 0) {
                ++n2;
            } else {
                ++n3;
            }
            int n5 = LiteralsUtils.toInternal(n4);
            IVecInt iVecInt2 = this.sizeoccurrences[n5];
            if (iVecInt2 == null) {
                this.sizeoccurrences[n5] = iVecInt2 = new VecInt();
            }
            iVecInt2.push(n);
        }
        if (n3 == 0) {
            ++this.allpositive;
        } else if (n2 == 0) {
            ++this.allnegative;
        } else if (n2 == 1) {
            ++this.horn;
        } else if (n3 == 1) {
            ++this.dualhorn;
        }
        return null;
    }

    @Override
    public IConstr addBlockingClause(IVecInt iVecInt) throws ContradictionException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public boolean removeSubsumedConstr(IConstr iConstr) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setTimeout(int n) {
    }

    @Override
    public void setTimeoutOnConflicts(int n) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setTimeoutMs(long l) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public int getTimeout() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public long getTimeoutMs() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void expireTimeout() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void reset() {
    }

    @Override
    @Deprecated
    public void printStat(PrintStream printStream, String string) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    @Deprecated
    public void printStat(PrintWriter printWriter, String string) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void printStat(PrintWriter printWriter) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        int n7 = Integer.MAX_VALUE;
        int n8 = Integer.MIN_VALUE;
        int n9 = 0;
        if (this.sizeoccurrences == null) {
            return;
        }
        int n10 = this.sizeoccurrences.length - 1;
        int n11 = 1;
        while (n11 < n10) {
            int n12 = 0;
            boolean bl = false;
            int n13 = 0;
            while (n13 < 2) {
                IVecInt iVecInt = this.sizeoccurrences[n11 + n13];
                if (iVecInt == null) {
                    bl = true;
                } else {
                    ++n2;
                    int n14 = iVecInt.size();
                    n12 += n14;
                    if (n7 > n14) {
                        n7 = n14;
                    }
                    if (n14 > n8) {
                        n8 = n14;
                    }
                    n9 += n14;
                }
                ++n13;
            }
            if (n12 > 0) {
                if (bl) {
                    ++n3;
                }
                ++n;
                if (n4 > n12) {
                    n4 = n12;
                }
                if (n12 > n5) {
                    n5 = n12;
                }
                n6 += n12;
            }
            n11 += 2;
        }
        System.out.println("c Distribution of constraints size:");
        n11 = 0;
        for (Map.Entry<Integer, Counter> entry : this.sizes.entrySet()) {
            System.out.printf("c %d => %d%n", entry.getKey(), entry.getValue().getValue());
            n11 += entry.getValue().getValue();
        }
        System.out.printf("c Real number of variables, literals, number of clauses, #pureliterals, ", new Object[0]);
        System.out.printf("variable occurrences (min/max/avg) ", new Object[0]);
        System.out.printf("literals occurrences (min/max/avg) ", new Object[0]);
        System.out.println("Specific clauses: #positive  #negative #horn  #dualhorn #remaining");
        System.out.printf("%d %d %d %d %d %d %d %d %d %d ", n, n2, n11, n3, n4, n5, n6 / n, n7, n8, n9 / n2);
        System.out.printf("%d %d %d %d %d%n", this.allpositive, this.allnegative, this.horn, this.dualhorn, n11 - this.allpositive - this.allnegative - this.horn - this.dualhorn);
    }

    @Override
    public Map<String, Number> getStat() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public String toString(String string) {
        return String.valueOf(string) + "Statistics about the benchmarks";
    }

    @Override
    public void clearLearntClauses() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setDBSimplificationAllowed(boolean bl) {
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public <S extends ISolverService> void setSearchListener(SearchListener<S> searchListener) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public <S extends ISolverService> SearchListener<S> getSearchListener() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public boolean isVerbose() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setVerbose(boolean bl) {
    }

    @Override
    public void setLogPrefix(String string) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public String getLogPrefix() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public IVecInt unsatExplanation() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public int[] modelWithInternalVariables() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public int realNumberOfVariables() {
        return this.nbvars;
    }

    @Override
    public boolean isSolverKeptHot() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setKeepSolverHot(boolean bl) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public ISolver getSolvingEngine() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setUnitClauseProvider(UnitClauseProvider unitClauseProvider) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }
}

