/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.encodings;

import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.csp.Encoding;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySupportEncoding
implements Encoding {
    private final Map<Integer, IVecInt> supportsa = new HashMap<Integer, IVecInt>();
    private final Map<Integer, IVecInt> supportsb = new HashMap<Integer, IVecInt>();
    private static final Encoding instance = new BinarySupportEncoding();

    private BinarySupportEncoding() {
    }

    public static Encoding instance() {
        return instance;
    }

    @Override
    public void onFinish(ISolver iSolver, IVec<Var> iVec) throws ContradictionException {
        this.generateClauses(iVec.get(0), this.supportsa, iSolver);
        this.generateClauses(iVec.get(1), this.supportsb, iSolver);
    }

    @Override
    public void onInit(ISolver iSolver, IVec<Var> iVec) {
        this.supportsa.clear();
        this.supportsb.clear();
    }

    @Override
    public void onNogood(ISolver iSolver, IVec<Var> iVec, Map<Evaluable, Integer> map) throws ContradictionException {
    }

    @Override
    public void onSupport(ISolver iSolver, IVec<Var> iVec, Map<Evaluable, Integer> map) throws ContradictionException {
        Var var = iVec.get(0);
        Integer n = map.get(var);
        Var var2 = iVec.get(1);
        Integer n2 = map.get(var2);
        this.addSupport(n, var2, n2, this.supportsa);
        this.addSupport(n2, var, n, this.supportsb);
    }

    private void addSupport(Integer n, Evaluable evaluable, Integer n2, Map<Integer, IVecInt> map) {
        IVecInt iVecInt = map.get(n);
        if (iVecInt == null) {
            iVecInt = new VecInt();
            map.put(n, iVecInt);
        }
        iVecInt.push(evaluable.translate(n2));
    }

    private void generateClauses(Evaluable evaluable, Map<Integer, IVecInt> map, ISolver iSolver) throws ContradictionException {
        VecInt vecInt = new VecInt();
        IteratorInt iteratorInt = evaluable.domain().iterator();
        while (iteratorInt.hasNext()) {
            Integer n = new Integer(iteratorInt.next());
            vecInt.clear();
            IVecInt iVecInt = map.get(n);
            vecInt.push(-evaluable.translate(n));
            if (iVecInt != null) {
                IteratorInt iteratorInt2 = iVecInt.iterator();
                while (iteratorInt2.hasNext()) {
                    vecInt.push(iteratorInt2.next());
                }
            }
            iSolver.addClause(vecInt);
        }
    }
}

