/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.xml;

import org.sat4j.csp.xml.CSPFormatException;
import org.sat4j.csp.xml.Element;
import org.sat4j.csp.xml.ICSPCallback;
import org.sat4j.csp.xml.InstanceParser;
import org.xml.sax.Attributes;

class Parameters
extends Element {
    private StringBuilder allParameters;
    private InstanceParser ip;

    public Parameters(ICSPCallback iCSPCallback, String string, InstanceParser instanceParser) {
        super(iCSPCallback, string);
        this.ip = instanceParser;
    }

    public void startElement(Attributes attributes) {
        this.allParameters = new StringBuilder();
    }

    public void characters(String string) {
        this.allParameters.append(string);
    }

    public void endElement() {
        if (this.ip.getParentElement().tagName().equals("constraint")) {
            this.effectiveParameters();
        } else {
            this.formalParameters();
        }
    }

    private void formalParameters() {
        String[] stringArray = this.allParameters.toString().trim().split("\\s+");
        int n = 0;
        while (n < stringArray.length && !stringArray[n].equals("")) {
            String string = stringArray[n];
            if (!string.equals("int")) {
                throw new CSPFormatException(String.valueOf(string) + " type for parameters not supported");
            }
            if (++n == stringArray.length || stringArray[n].equals("")) {
                throw new CSPFormatException("a parameter name is missing.");
            }
            String string2 = stringArray[n];
            this.getCB().addFormalParameter(string2, string);
            ++n;
        }
    }

    private void effectiveParameters() {
        String[] stringArray;
        String[] stringArray2 = stringArray = this.allParameters.toString().trim().split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (!string.equals("")) {
                try {
                    this.getCB().addEffectiveParameter(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.getCB().addEffectiveParameter(string);
                }
            }
            ++n2;
        }
    }
}

