/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.tools.DisjunctionRHS;
import org.sat4j.pb.tools.INegator;
import org.sat4j.pb.tools.ImplicationNamer;
import org.sat4j.pb.tools.ImplicationRHS;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.pb.tools.XplainPB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.GateTranslator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyHelper<T, C> {
    public final INegator<T> NO_NEGATION = new INegator<T>(){

        @Override
        public boolean isNegated(T t) {
            return false;
        }

        @Override
        public T unNegate(T t) {
            return t;
        }
    };
    private static final long serialVersionUID = 1L;
    private final Map<T, Integer> mapToDimacs = new HashMap<T, Integer>();
    private final Map<Integer, T> mapToDomain = new HashMap<Integer, T>();
    final Map<IConstr, C> descs = new HashMap<IConstr, C>();
    private final XplainPB xplain;
    private final GateTranslator gator;
    final IPBSolver solver;
    private INegator<T> negator = this.NO_NEGATION;
    private ObjectiveFunction objFunction;
    private IVecInt objLiterals;
    private IVec<BigInteger> objCoefs;
    public boolean explanationEnabled = true;

    public DependencyHelper(IPBSolver iPBSolver) {
        this(iPBSolver, true);
    }

    public DependencyHelper(IPBSolver iPBSolver, boolean bl) {
        if (bl) {
            this.xplain = new XplainPB(iPBSolver);
            this.solver = this.xplain;
        } else {
            this.xplain = null;
            this.solver = iPBSolver;
        }
        this.gator = new GateTranslator(this.solver);
    }

    public void setNegator(INegator<T> iNegator) {
        this.negator = iNegator;
    }

    int getIntValue(T t) {
        boolean bl = this.negator.isNegated(t);
        T t2 = bl ? this.negator.unNegate(t) : t;
        Integer n = this.mapToDimacs.get(t2);
        if (n == null) {
            n = new Integer(this.solver.nextFreeVarId(true));
            this.mapToDomain.put(n, t);
            this.mapToDimacs.put(t, n);
        }
        if (bl) {
            return -n.intValue();
        }
        return n;
    }

    public IVec<T> getSolution() {
        int[] nArray = this.solver.model();
        Vec<T> vec = new Vec<T>();
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            if (n3 > 0) {
                vec.push(this.mapToDomain.get(new Integer(n3)));
            }
            ++n2;
        }
        return vec;
    }

    public BigInteger getSolutionCost() {
        return this.objFunction.calculateDegree(this.solver.model());
    }

    public boolean getBooleanValueFor(T t) {
        return this.solver.model(this.getIntValue(t));
    }

    public boolean hasASolution() throws TimeoutException {
        return this.solver.isSatisfiable();
    }

    public boolean hasASolution(IVec<T> iVec) throws TimeoutException {
        VecInt vecInt = new VecInt();
        Iterator<T> iterator = iVec.iterator();
        while (iterator.hasNext()) {
            vecInt.push(this.getIntValue(iterator.next()));
        }
        return this.solver.isSatisfiable(vecInt);
    }

    public boolean hasASolution(Collection<T> collection) throws TimeoutException {
        VecInt vecInt = new VecInt();
        for (T t : collection) {
            vecInt.push(this.getIntValue(t));
        }
        return this.solver.isSatisfiable(vecInt);
    }

    public Set<C> why() throws TimeoutException {
        if (!this.explanationEnabled) {
            throw new UnsupportedOperationException("Explanation not enabled!");
        }
        Collection<IConstr> collection = this.xplain.explain();
        TreeSet<C> treeSet = new TreeSet<C>();
        for (IConstr iConstr : collection) {
            C c = this.descs.get(iConstr);
            if (c == null) continue;
            treeSet.add(c);
        }
        return treeSet;
    }

    public Set<C> why(T t) throws TimeoutException {
        VecInt vecInt = new VecInt();
        vecInt.push(-this.getIntValue(t));
        return this.why(vecInt);
    }

    public Set<C> whyNot(T t) throws TimeoutException {
        VecInt vecInt = new VecInt();
        vecInt.push(this.getIntValue(t));
        return this.why(vecInt);
    }

    private Set<C> why(IVecInt iVecInt) throws TimeoutException {
        if (this.xplain.isSatisfiable(iVecInt)) {
            return Collections.emptySet();
        }
        return this.why();
    }

    public void setTrue(T t, C c) throws ContradictionException {
        this.descs.put(this.gator.gateTrue(this.getIntValue(t)), c);
    }

    public void setFalse(T t, C c) throws ContradictionException {
        this.descs.put(this.gator.gateFalse(this.getIntValue(t)), c);
    }

    public ImplicationRHS<T, C> implication(T[] TArray) {
        VecInt vecInt = new VecInt();
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            vecInt.push(-this.getIntValue(t));
            ++n2;
        }
        return new ImplicationRHS(this, vecInt);
    }

    public DisjunctionRHS<T, C> disjunction(T[] TArray) {
        VecInt vecInt = new VecInt();
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            vecInt.push(-this.getIntValue(t));
            ++n2;
        }
        return new DisjunctionRHS(this, vecInt);
    }

    public ImplicationNamer<T, C> atMost(int n, T[] TArray) throws ContradictionException {
        Vec<IConstr> vec = new Vec<IConstr>();
        VecInt vecInt = new VecInt();
        T[] TArray2 = TArray;
        int n2 = TArray.length;
        int n3 = 0;
        while (n3 < n2) {
            T t = TArray2[n3];
            vecInt.push(this.getIntValue(t));
            ++n3;
        }
        vec.push(this.solver.addAtMost(vecInt, n));
        return new ImplicationNamer(this, vec);
    }

    public void clause(C c, T[] TArray) throws ContradictionException {
        VecInt vecInt = new VecInt(TArray.length);
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray2[n2];
            vecInt.push(this.getIntValue(t));
            ++n2;
        }
        this.descs.put(this.gator.addClause(vecInt), c);
    }

    public void iff(C c, T t, T[] TArray) throws ContradictionException {
        Object object;
        VecInt vecInt = new VecInt(TArray.length);
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = TArray2[n2];
            vecInt.push(this.getIntValue(object));
            ++n2;
        }
        Object object2 = object = this.gator.iff(this.getIntValue(t), vecInt);
        int n3 = ((T)object2).length;
        n = 0;
        while (n < n3) {
            T t2 = object2[n];
            this.descs.put((IConstr)t2, c);
            ++n;
        }
    }

    public void and(C c, T t, T[] TArray) throws ContradictionException {
        Object object;
        VecInt vecInt = new VecInt(TArray.length);
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = TArray2[n2];
            vecInt.push(this.getIntValue(object));
            ++n2;
        }
        Object object2 = object = this.gator.and(this.getIntValue(t), vecInt);
        int n3 = ((T)object2).length;
        n = 0;
        while (n < n3) {
            T t2 = object2[n];
            this.descs.put((IConstr)t2, c);
            ++n;
        }
    }

    public void or(C c, T t, T[] TArray) throws ContradictionException {
        Object object;
        VecInt vecInt = new VecInt(TArray.length);
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = TArray2[n2];
            vecInt.push(this.getIntValue(object));
            ++n2;
        }
        Object object2 = object = this.gator.or(this.getIntValue(t), vecInt);
        int n3 = ((T)object2).length;
        n = 0;
        while (n < n3) {
            T t2 = object2[n];
            this.descs.put((IConstr)t2, c);
            ++n;
        }
    }

    public void ifThenElse(C c, T t, T t2, T t3, T t4) throws ContradictionException {
        IConstr[] iConstrArray;
        IConstr[] iConstrArray2 = iConstrArray = this.gator.ite(this.getIntValue(t), this.getIntValue(t2), this.getIntValue(t3), this.getIntValue(t4));
        int n = iConstrArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConstr iConstr = iConstrArray2[n2];
            this.descs.put(iConstr, c);
            ++n2;
        }
    }

    public void setObjectiveFunction(WeightedObject<T>[] weightedObjectArray) {
        this.createObjectivetiveFunctionIfNeeded(weightedObjectArray.length);
        WeightedObject<T>[] weightedObjectArray2 = weightedObjectArray;
        int n = weightedObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            WeightedObject<T> weightedObject = weightedObjectArray2[n2];
            this.objLiterals.push(this.getIntValue(weightedObject.thing));
            this.objCoefs.push(weightedObject.getWeight());
            ++n2;
        }
    }

    private void createObjectivetiveFunctionIfNeeded(int n) {
        if (this.objFunction == null) {
            this.objLiterals = new VecInt(n);
            this.objCoefs = new Vec<BigInteger>(n);
            this.objFunction = new ObjectiveFunction(this.objLiterals, this.objCoefs);
            this.solver.setObjectiveFunction(this.objFunction);
        }
    }

    public void addToObjectiveFunction(T t, int n) {
        this.addToObjectiveFunction(t, BigInteger.valueOf(n));
    }

    public void addToObjectiveFunction(T t, BigInteger bigInteger) {
        this.createObjectivetiveFunctionIfNeeded(20);
        this.objLiterals.push(this.getIntValue(t));
        this.objCoefs.push(bigInteger);
    }

    public void stopSolver() {
        this.solver.expireTimeout();
    }

    public void stopExplanation() {
        if (!this.explanationEnabled) {
            throw new UnsupportedOperationException("Explanation not enabled!");
        }
        this.xplain.cancelExplanation();
    }

    public void discard(IVec<T> iVec) throws ContradictionException {
        VecInt vecInt = new VecInt(iVec.size());
        Iterator<T> iterator = iVec.iterator();
        while (iterator.hasNext()) {
            vecInt.push(-this.getIntValue(iterator.next()));
        }
        this.solver.addClause(vecInt);
    }

    public String getObjectiveFunction() {
        ObjectiveFunction objectiveFunction = this.solver.getObjectiveFunction();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectiveFunction.getVars().size()) {
            stringBuffer.append(new StringBuffer().append(objectiveFunction.getCoeffs().get(n)).append(objectiveFunction.getVars().get(n) > 0 ? " " : "~").append(this.mapToDomain.get(new Integer(Math.abs(objectiveFunction.getVars().get(n))))).append(" ").toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getNumberOfVariables() {
        return this.mapToDimacs.size();
    }

    public int getNumberOfConstraints() {
        return this.descs.size();
    }
}

