/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Iterator;
import org.sat4j.core.Vec;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.xplain.Xplain;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XplainPB
extends Xplain<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;

    public XplainPB(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        Vec<BigInteger> vec = new Vec<BigInteger>();
        vec.growTo(iVecInt.size(), BigInteger.ONE);
        int n2 = this.createNewVar(iVecInt);
        iVecInt.push(n2);
        BigInteger bigInteger = BigInteger.valueOf(n - vec.size());
        vec.push(bigInteger);
        IConstr iConstr = ((IPBSolver)this.decorated()).addPseudoBoolean(iVecInt, vec, false, BigInteger.valueOf(n));
        if (iConstr == null) {
            this.discardLastestVar();
        } else {
            this.constrs.put(new Integer(n2), iConstr);
        }
        return iConstr;
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        Object object;
        int n = this.createNewVar(iVecInt);
        iVecInt.push(n);
        if (bl && bigInteger.signum() >= 0) {
            iVec.push(bigInteger);
        } else {
            object = BigInteger.ZERO;
            Iterator<BigInteger> iterator = iVec.iterator();
            while (iterator.hasNext()) {
                object = ((BigInteger)object).add(iterator.next());
            }
            object = ((BigInteger)object).subtract(bigInteger);
            iVec.push(((BigInteger)object).negate());
        }
        object = ((IPBSolver)this.decorated()).addPseudoBoolean(iVecInt, iVec, bl, bigInteger);
        if (object == null) {
            this.discardLastestVar();
        } else {
            this.constrs.put(new Integer(n), object);
        }
        return object;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        ((IPBSolver)this.decorated()).setObjectiveFunction(objectiveFunction);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return ((IPBSolver)this.decorated()).getObjectiveFunction();
    }
}

