/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.intervalorders;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.sat4j.core.Vec;
import org.sat4j.intervalorders.IRelation;
import org.sat4j.intervalorders.Indifferent;
import org.sat4j.intervalorders.Interval;
import org.sat4j.intervalorders.NegRelation;
import org.sat4j.intervalorders.Prefer;
import org.sat4j.intervalorders.RelationNegator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.reader.EfficientScanner;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactMatrixReader
extends org.sat4j.reader.Reader {
    private EfficientScanner scanner;
    private final IPBSolver pbsolver;
    private final DependencyHelper<IRelation, String> helper;
    private Prefer[] prefers;
    private Indifferent[] indifferents;
    private int numberOfAlternatives;
    private int numberOfVoters;
    private static final Random rand = new Random();

    public CompactMatrixReader(IPBSolver iPBSolver) {
        this.pbsolver = iPBSolver;
        this.helper = new DependencyHelper(iPBSolver, false);
        this.helper.setNegator(new RelationNegator());
    }

    @Override
    public String decode(int[] nArray) {
        return this.helper.getSolution().toString();
    }

    @Override
    public void decode(int[] nArray, PrintWriter printWriter) {
        printWriter.println(this.helper.getSolution());
    }

    private int[][] generateRandomCompactMatrix(int n, int n2) {
        int[][] nArray = new int[n][n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int[][] nArray2 = this.generateRandomVote(n);
            if (this.checkVote(nArray2)) {
                ++n3;
                if (n2 <= 100) {
                    System.out.println(new StringBuffer("Voter ").append(n3).toString());
                    this.displayMatrix(nArray2);
                }
                this.agregateVotes(nArray2, nArray);
            }
            ++n4;
        }
        System.out.printf("Generated %d random votes to reach %d correct votes\n", new Integer(n4), new Integer(n3));
        return nArray;
    }

    public void generateRandomCase(int n, int n2, long l) throws ContradictionException {
        rand.setSeed(l);
        this.generateRandomCase(n, n2);
    }

    public void generateRandomCase(int n, int n2) throws ContradictionException {
        String[] stringArray = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray[n3] = new StringBuffer("alt").append(n3 + 1).toString();
            ++n3;
        }
        this.createPreferenceObjects(stringArray);
        this.numberOfAlternatives = n;
        this.numberOfVoters = n2;
        this.createStructuralConstraints(n);
        int[][] nArray = this.generateRandomCompactMatrix(n, n2);
        System.out.println("Compact Matrix");
        this.displayMatrix(nArray);
        this.handleMatrix(this.numberOfAlternatives, this.numberOfVoters, nArray);
        System.out.println("Creating hard constraints");
        this.createHardConstraints(this.numberOfAlternatives, this.numberOfVoters);
        System.out.println("Creating optimization function");
        this.createOptimizationFunction(this.numberOfAlternatives, this.numberOfVoters);
    }

    private boolean checkVote(int[][] nArray) {
        Vec<IRelation> vec = new Vec<IRelation>(nArray.length * nArray.length);
        int n = 0;
        while (n < nArray.length) {
            int n2 = n + 1;
            while (n2 < nArray[n].length) {
                if (nArray[n][n2] == 1) {
                    vec.push(this.prefers(n, n2));
                } else if (nArray[n2][n] == 1) {
                    vec.push(this.prefers(n2, n));
                } else {
                    vec.push(this.indif(n, n2));
                }
                ++n2;
            }
            vec.push(this.indif(n, n));
            ++n;
        }
        try {
            return this.helper.hasASolution(vec);
        }
        catch (TimeoutException timeoutException) {
            return false;
        }
    }

    private int[][] generateRandomVote(int n) {
        int[][] nArray = new int[n][n];
        Interval[] intervalArray = new Interval[n];
        int n2 = n * 100;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = rand.nextInt(n2) + 1;
            int n6 = n4 = n5 + rand.nextInt(n) + 1;
            int n7 = n5;
            intervalArray[n3] = new Interval(n6, n7);
            ++n3;
        }
        System.out.println(Arrays.asList(intervalArray));
        n3 = 0;
        while (n3 < n) {
            int n8 = n3 + 1;
            while (n8 < n) {
                switch (intervalArray[n3].compareTo(intervalArray[n8])) {
                    case 0: {
                        nArray[n3][n8] = 0;
                        nArray[n8][n3] = 0;
                        break;
                    }
                    case -1: {
                        nArray[n3][n8] = 1;
                        nArray[n8][n3] = 0;
                        break;
                    }
                    case 1: {
                        nArray[n3][n8] = 0;
                        nArray[n8][n3] = 1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Should never happen");
                    }
                }
                ++n8;
            }
            nArray[n3][n3] = 0;
            ++n3;
        }
        return nArray;
    }

    private void agregateVotes(int[][] nArray, int[][] nArray2) {
        int n = 0;
        while (n < nArray2.length) {
            int n2 = 0;
            while (n2 < nArray2[n].length) {
                int[] nArray3 = nArray2[n];
                int n3 = n2;
                nArray3[n3] = nArray3[n3] + nArray[n][n2];
                nArray[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
    }

    private void displayMatrix(int[][] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                System.out.printf("%5d", new Integer(nArray[n][n2]));
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    @Override
    public IProblem parseInstance(InputStream inputStream) throws ParseFormatException, ContradictionException, IOException {
        int[][] nArray = this.readMatrixFromFile(inputStream);
        this.createStructuralConstraints(this.numberOfAlternatives);
        this.handleMatrix(this.numberOfAlternatives, this.numberOfVoters, nArray);
        System.out.println("Creating hard constraints");
        this.createHardConstraints(this.numberOfAlternatives, this.numberOfVoters);
        System.out.println("Creating optimization function");
        this.createOptimizationFunction(this.numberOfAlternatives, this.numberOfVoters);
        return this.pbsolver;
    }

    private int[][] readMatrixFromFile(InputStream inputStream) throws IOException, ParseFormatException {
        int n;
        this.scanner = new EfficientScanner(inputStream);
        String string = this.scanner.nextLine();
        String[] stringArray = string.split("\\s+");
        this.numberOfAlternatives = n = this.createPreferenceObjects(stringArray);
        this.numberOfVoters = this.scanner.nextInt();
        System.out.println("Reading vote data");
        int[][] nArray = new int[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                nArray[n2][n3] = this.scanner.nextInt();
                ++n3;
            }
            ++n2;
        }
        return nArray;
    }

    private void handleMatrix(int n, int n2, int[][] nArray) {
        int n3;
        int n4 = 0;
        while (n4 < n) {
            n3 = 0;
            while (n3 < n) {
                if (n4 != n3) {
                    this.prefers(n4, n3).setNumberOfVotes(nArray[n4][n3]);
                } else if (nArray[n4][n3] != 0) {
                    throw new IllegalStateException("Cannot prefer an alternative to itself.");
                }
                ++n3;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            n3 = n4 + 1;
            while (n3 < n) {
                this.indif(n4, n3).setNumberOfVotes(n2 - this.prefers(n4, n3).getNumberOfVotes() - this.prefers(n3, n4).getNumberOfVotes());
                ++n3;
            }
            ++n4;
        }
    }

    private int createPreferenceObjects(String[] stringArray) {
        int n = stringArray.length * stringArray.length;
        this.prefers = new Prefer[n];
        this.indifferents = new Indifferent[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (n2 != n3) {
                    this.prefers[n2 * stringArray.length + n3] = new Prefer(stringArray[n2], stringArray[n3]);
                }
                this.indifferents[n2 * stringArray.length + n3] = new Indifferent(stringArray[n2], stringArray[n3]);
                ++n3;
            }
            ++n2;
        }
        return stringArray.length;
    }

    private Prefer prefers(int n, int n2) {
        Prefer prefer = this.prefers[n * this.numberOfAlternatives + n2];
        if (prefer == null) {
            throw new IllegalStateException();
        }
        return prefer;
    }

    private Indifferent indif(int n, int n2) {
        Indifferent indifferent = this.indifferents[n * this.numberOfAlternatives + n2];
        if (indifferent == null) {
            throw new IllegalStateException();
        }
        return indifferent;
    }

    private static IRelation neg(IRelation iRelation) {
        return new NegRelation(iRelation);
    }

    private void createStructuralConstraints(int n) throws ContradictionException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n2 = n4 + 1;
            while (n2 < n) {
                this.helper.clause("Completeness", (IRelation[])new IRelation[]{this.prefers(n4, n2), this.indif(n4, n2), this.prefers(n2, n4)});
                this.helper.clause("Assymetry", (IRelation[])new IRelation[]{CompactMatrixReader.neg(this.prefers(n4, n2)), CompactMatrixReader.neg(this.prefers(n2, n4))});
                this.helper.clause("Exclusivity", (IRelation[])new IRelation[]{CompactMatrixReader.neg(this.prefers(n4, n2)), CompactMatrixReader.neg(this.indif(n4, n2))});
                this.helper.clause("Exclusivity", (IRelation[])new IRelation[]{CompactMatrixReader.neg(this.prefers(n2, n4)), CompactMatrixReader.neg(this.indif(n4, n2))});
                n3 += 4;
                ++n2;
            }
            this.helper.setTrue(this.indif(n4, n4), "Reflexivity");
            ++n3;
            ++n4;
        }
        System.out.printf("Created %d constraints without Ferrer condition\n", new Integer(n3));
        n4 = 0;
        while (n4 < n) {
            n2 = 0;
            while (n2 < n) {
                int n5 = 0;
                while (n5 < n) {
                    int n6 = 0;
                    while (n6 < n) {
                        if (n4 != n2 && n5 != n6 && n4 != n6 && n2 != n6 && n4 != n5) {
                            this.helper.implication((IRelation[])new IRelation[]{this.prefers(n4, n2), this.indif(n2, n5), this.prefers(n5, n6)}).implies(this.prefers(n4, n6)).named("Ferrers");
                            ++n3;
                        }
                        ++n6;
                    }
                    ++n5;
                }
                ++n2;
            }
            ++n4;
        }
        System.out.printf("Created %d hard constraints\n", new Integer(n3));
    }

    private void createInstanceConstraints(int n, int n2) throws ContradictionException {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4 + 1;
            while (n5 < n) {
                if (this.prefers(n4, n5).getNumberOfVotes() == n2) {
                    this.helper.setTrue(this.prefers(n4, n5), "Unanimity P");
                    ++n3;
                } else if (this.prefers(n5, n4).getNumberOfVotes() == n2) {
                    this.helper.setTrue(this.prefers(n5, n4), "Unanimity P");
                    ++n3;
                } else if (this.prefers(n4, n5).getNumberOfVotes() == 0 && this.prefers(n5, n4).getNumberOfVotes() == 0) {
                    this.helper.setTrue(this.indif(n4, n5), "Unanimity I");
                    ++n3;
                }
                ++n5;
            }
            ++n4;
        }
        System.out.printf("Created %d instance specific constraints\n", new Integer(n3));
    }

    private void createHardConstraints(int n, int n2) throws ContradictionException {
        this.createInstanceConstraints(n, n2);
    }

    private void createOptimizationFunction(int n, int n2) {
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3 + 1;
            while (n4 < n) {
                this.prefers(n3, n4).setPenalty(n2 + this.prefers(n4, n3).getNumberOfVotes() - this.prefers(n3, n4).getNumberOfVotes());
                this.helper.addToObjectiveFunction((IRelation)this.prefers(n3, n4), this.prefers(n3, n4).getPenalty());
                this.prefers(n4, n3).setPenalty(n2 + this.prefers(n3, n4).getNumberOfVotes() - this.prefers(n4, n3).getNumberOfVotes());
                this.helper.addToObjectiveFunction((IRelation)this.prefers(n4, n3), this.prefers(n4, n3).getPenalty());
                this.indif(n3, n4).setPenalty(this.prefers(n3, n4).getNumberOfVotes() + this.prefers(n4, n3).getNumberOfVotes());
                this.helper.addToObjectiveFunction((IRelation)this.indif(n3, n4), this.indif(n3, n4).getPenalty());
                ++n4;
            }
            ++n3;
        }
    }

    @Override
    public IProblem parseInstance(Reader reader) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException();
    }

    public boolean hasSolution() throws TimeoutException {
        return this.helper.hasASolution();
    }

    public IVec<IRelation> getSolution() throws ContradictionException {
        return this.helper.getSolution();
    }

    public void discardLastSolution() throws ContradictionException {
        this.helper.discard(this.helper.getSolution());
    }

    public Set<String> why() throws TimeoutException {
        return this.helper.why();
    }

    public int getSolutionCost() {
        return this.helper.getSolutionCost().intValue();
    }

    public String getObjectiveFunction() {
        return this.helper.getObjectiveFunction();
    }

    public int numberOfAlternatives() {
        return this.numberOfAlternatives;
    }

    public int nbVoters() {
        return this.numberOfVoters;
    }

    public int nVars() {
        return this.helper.getNumberOfVariables();
    }

    public int nConstraints() {
        return this.helper.getNumberOfConstraints();
    }

    public Map<Integer, IRelation> mapping() {
        return this.helper.getVariablesMapping();
    }

    public void discardNotOptimalValues(long l) throws ContradictionException {
        this.helper.discardSolutionsWithObjectiveValueGreaterThan(l);
    }
}

