/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.intervalorders;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Iterator;
import org.sat4j.intervalorders.CompactMatrixReader;
import org.sat4j.intervalorders.IRelation;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.SolverFactory;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tester {
    public static void main(String[] stringArray) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        String string;
        if (stringArray.length < 1) {
            System.out.println("Usage: java -jar intervalorders.jar <filename>");
            return;
        }
        OptToPBSATAdapter optToPBSATAdapter = new OptToPBSATAdapter(new PseudoOptDecorator(SolverFactory.newCuttingPlanes()));
        optToPBSATAdapter.setTimeout(600);
        CompactMatrixReader compactMatrixReader = new CompactMatrixReader(optToPBSATAdapter);
        if (stringArray.length >= 2) {
            System.out.println(new StringBuffer("Generating random cases with ").append(stringArray[0]).append(" alternatives and ").append(stringArray[1]).append(" voters").toString());
            int n = Integer.valueOf(stringArray[0]);
            int n2 = Integer.valueOf(stringArray[1]);
            string = new StringBuffer("random-interval-orders-").append(stringArray[0]).append("-").append(stringArray[1]).toString();
            if (stringArray.length == 3) {
                System.out.println(new StringBuffer("Using seed ").append(stringArray[2]).append(" to initialize random generator").toString());
                compactMatrixReader.generateRandomCase(n, n2, Long.valueOf(stringArray[2]));
                string = new StringBuffer(String.valueOf(string)).append("-").append(stringArray[2]).toString();
            } else {
                compactMatrixReader.generateRandomCase(n, n2);
            }
        } else {
            String string2 = stringArray[0];
            System.out.println("Reading problem ...");
            compactMatrixReader.parseInstance(string2);
            string = string2.substring(0, string2.lastIndexOf(46));
        }
        PrintStream printStream = new PrintStream(new FileOutputStream(new StringBuffer(String.valueOf(string)).append(".opb").toString()));
        printStream.println(optToPBSATAdapter.toString());
        printStream.close();
        System.out.println(new StringBuffer("Number of alternatives:\t").append(compactMatrixReader.numberOfAlternatives()).toString());
        System.out.println(new StringBuffer("Number of variables:\t").append(compactMatrixReader.nVars()).toString());
        System.out.println(new StringBuffer("Variables mapping:\t").append(compactMatrixReader.mapping()).toString());
        System.out.println(new StringBuffer("Number of constraints:\t").append(compactMatrixReader.nConstraints()).toString());
        System.out.println(new StringBuffer("Objective Function:\t").append(compactMatrixReader.getObjectiveFunction()).toString());
        long l = Tester.sumOfWeights(optToPBSATAdapter);
        System.out.println(new StringBuffer("Sum of weights:\t\t").append(l).toString());
        int n = 1;
        boolean bl = true;
        try {
            while (compactMatrixReader.hasSolution()) {
                IVec<IRelation> iVec = compactMatrixReader.getSolution();
                long l2 = compactMatrixReader.getSolutionCost();
                System.out.println(new StringBuffer().append(iVec).append(" > ").append(l2).append("/").append(l - l2).toString());
                Tester.convertToDotFile(iVec, string, compactMatrixReader.nbVoters(), n++, l2);
                compactMatrixReader.discardLastSolution();
                if (!bl) continue;
                compactMatrixReader.discardNotOptimalValues(l2);
                bl = false;
            }
        }
        catch (TimeoutException timeoutException) {
            IVec<IRelation> iVec = compactMatrixReader.getSolution();
            long l3 = compactMatrixReader.getSolutionCost();
            System.out.println(new StringBuffer().append(iVec).append(" > non optimal ").append(l3).append("/").append(l - l3).toString());
            Tester.convertToDotFile(iVec, stringArray[0], compactMatrixReader.nbVoters(), n++, l3);
        }
    }

    private static void convertToDotFile(IVec<IRelation> iVec, String string, int n, int n2, long l) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(new StringBuffer(String.valueOf(string)).append(".sol").append(n2).append(".dot").toString()));
            printWriter.println("digraph G {");
            printWriter.println(new StringBuffer(" legend [shape= plaintext, label=\"Solution ").append(n2).append(", penalty ").append(l).append("\"]").toString());
            Iterator<IRelation> iterator = iVec.iterator();
            while (iterator.hasNext()) {
                printWriter.println(iterator.next().toDot(n));
            }
            printWriter.println("}");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static long sumOfWeights(IPBSolver iPBSolver) {
        IVec<BigInteger> iVec = iPBSolver.getObjectiveFunction().getCoeffs();
        long l = 0L;
        Iterator<BigInteger> iterator = iVec.iterator();
        while (iterator.hasNext()) {
            l += (long)iterator.next().intValue();
        }
        return l;
    }
}

