/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import java.util.Map;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.DimacsStringSolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserFriendlyPBStringSolver<T>
extends DimacsStringSolver
implements IPBSolver {
    private static final String FAKE_I_CONSTR_MSG = "Fake IConstr";
    private static final long serialVersionUID = 1L;
    private int indxConstrObj;
    private int nbOfConstraints;
    private ObjectiveFunction obj;
    private boolean inserted = false;
    private static final IConstr FAKE_CONSTR;
    private Map<Integer, T> mapping;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.UserFriendlyPBStringSolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        FAKE_CONSTR = new IConstr(){

            public int size() {
                throw new UnsupportedOperationException(UserFriendlyPBStringSolver.FAKE_I_CONSTR_MSG);
            }

            public boolean learnt() {
                throw new UnsupportedOperationException(UserFriendlyPBStringSolver.FAKE_I_CONSTR_MSG);
            }

            public double getActivity() {
                throw new UnsupportedOperationException(UserFriendlyPBStringSolver.FAKE_I_CONSTR_MSG);
            }

            public int get(int n) {
                throw new UnsupportedOperationException(UserFriendlyPBStringSolver.FAKE_I_CONSTR_MSG);
            }
        };
    }

    public UserFriendlyPBStringSolver() {
    }

    public UserFriendlyPBStringSolver(int n) {
        super(n);
    }

    public void setMapping(Map<Integer, T> map) {
        this.mapping = map;
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        ++this.nbOfConstraints;
        if (bl) {
            int n = 0;
            while (n < iVecInt.size()) {
                stringBuffer.append(new StringBuffer().append(iVec.get(n)).append(" ").append(this.mapping.get(new Integer(iVecInt.get(n)))).append(" + ").toString());
                ++n;
            }
            stringBuffer.append(new StringBuffer(">= ").append(bigInteger).append(" ;\n").toString());
        } else {
            int n = 0;
            while (n < iVecInt.size()) {
                stringBuffer.append(new StringBuffer().append(iVec.get(n)).append(" ").append(this.mapping.get(new Integer(iVecInt.get(n)))).append(" + ").toString());
                ++n;
            }
            stringBuffer.append(new StringBuffer("<= ").append(bigInteger).append(" ;\n").toString());
        }
        return FAKE_CONSTR;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.obj = objectiveFunction;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            stringBuffer.append(this.mapping.get(new Integer(iteratorInt.next())));
            stringBuffer.append(" ");
            if (!iteratorInt.hasNext()) continue;
            stringBuffer.append("+ ");
        }
        stringBuffer.append(new StringBuffer(">= ").append(n).append(" ;\n").toString());
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            stringBuffer.append(this.mapping.get(new Integer(iteratorInt.next())));
            stringBuffer.append(" ");
            if (!iteratorInt.hasNext()) continue;
            stringBuffer.append("+ ");
        }
        stringBuffer.append(new StringBuffer("<= ").append(n).append(" ;\n").toString());
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        boolean bl = true;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n = iteratorInt.next();
            if (n > 0) {
                if (bl) {
                    stringBuffer.append("-> ");
                    bl = false;
                }
                stringBuffer.append(this.mapping.get(new Integer(n)));
            } else {
                stringBuffer.append(this.mapping.get(new Integer(-n)));
            }
            stringBuffer.append(" ");
            if (!iteratorInt.hasNext() || bl) continue;
            stringBuffer.append("OR ");
        }
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    public String getExplanation() {
        return null;
    }

    public void setListOfVariablesForExplanation(IVecInt iVecInt) {
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = this.getOut();
        if (!this.inserted) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("* #variable= ");
            stringBuffer2.append(this.nVars());
            stringBuffer2.append(" #constraint= ");
            stringBuffer2.append(this.nbOfConstraints);
            stringBuffer2.append(" \n");
            if (this.obj != null) {
                stringBuffer2.append("min: ");
                stringBuffer2.append(this.obj);
                stringBuffer2.append(" ;\n");
            }
            stringBuffer.insert(this.indxConstrObj, stringBuffer2.toString());
            this.inserted = true;
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString(String string) {
        return "OPB output solver";
    }

    @Override
    public int newVar(int n) {
        StringBuffer stringBuffer = this.getOut();
        this.setNbVars(n);
        this.indxConstrObj = stringBuffer.length();
        stringBuffer.append("\n");
        return n;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.obj;
    }
}

