/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;

public class MaxWatchPb
extends WatchPb {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.MaxWatchPb");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private MaxWatchPb(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
    }

    private MaxWatchPb(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        super(nArray, bigIntegerArray, bigInteger);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
    }

    protected void computeWatches() throws ContradictionException {
        if (!$assertionsDisabled && !this.watchCumul.equals(BigInteger.ZERO)) {
            throw new AssertionError();
        }
        int n = 0;
        while (n < this.lits.length) {
            if (this.voc.isFalsified(this.lits[n])) {
                if (this.learnt) {
                    this.voc.undos(this.lits[n] ^ 1).push(this);
                    this.voc.watch(this.lits[n] ^ 1, this);
                }
            } else {
                this.voc.watch(this.lits[n] ^ 1, this);
                this.watchCumul = this.watchCumul.add(this.coefs[n]);
            }
            ++n;
        }
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
        if (!this.learnt && this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        int n = 0;
        while (n < this.coefs.length && this.watchCumul.subtract(this.coefs[n]).compareTo(this.degree) < 0) {
            if (this.voc.isUnassigned(this.lits[n]) && !unitPropagationListener.enqueue(this.lits[n], this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++n;
        }
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        this.voc.watch(n, this);
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError((Object)(this.watchCumul + "/" + this.recalcLeftSide() + ":" + this.learnt));
        }
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        BigInteger bigInteger = this.coefs[n2];
        BigInteger bigInteger2 = this.watchCumul.subtract(bigInteger);
        if (bigInteger2.compareTo(this.degree) < 0) {
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        this.voc.undos(n).push(this);
        this.watchCumul = bigInteger2;
        int n3 = 0;
        BigInteger bigInteger3 = this.watchCumul.subtract(this.degree);
        while (n3 < this.coefs.length && bigInteger3.compareTo(this.coefs[n3]) < 0) {
            if (this.voc.isUnassigned(this.lits[n3]) && !unitPropagationListener.enqueue(this.lits[n3], this)) {
                if (!$assertionsDisabled && this.isSatisfiable()) {
                    throw new AssertionError();
                }
                return false;
            }
            ++n3;
        }
        if (!$assertionsDisabled && !this.learnt && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchCumul.compareTo(this.recalcLeftSide()) < 0) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int n = 0;
        while (n < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[n])) {
                this.voc.watches(this.lits[n] ^ 1).remove(this);
            }
            ++n;
        }
    }

    public void undo(int n) {
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        if (!$assertionsDisabled && this.coefs[n2].signum() <= 0) {
            throw new AssertionError();
        }
        this.watchCumul = this.watchCumul.add(this.coefs[n2]);
    }

    public static MaxWatchPb normalizedMaxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        MaxWatchPb maxWatchPb = new MaxWatchPb(iLits, nArray, bigIntegerArray, bigInteger);
        if (maxWatchPb.degree.signum() <= 0) {
            return null;
        }
        maxWatchPb.computeWatches();
        maxWatchPb.computePropagation(unitPropagationListener);
        return maxWatchPb;
    }

    public static WatchPb normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MaxWatchPb(iLits, iDataStructurePB);
    }
}

