/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.sat4j.core.Vec;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.SearchListener;

public class DotSearchListener
implements SearchListener {
    private static final long serialVersionUID = 1L;
    private final Vec<String> pile = new Vec();
    private String currentNodeName = null;
    private transient Writer out;
    private boolean estOrange = false;

    public DotSearchListener(String string) {
        try {
            this.out = new FileWriter(string);
        }
        catch (IOException iOException) {
            System.err.println("Problem when created file.");
        }
    }

    public final void assuming(int n) {
        String string;
        int n2 = Math.abs(n);
        if (this.currentNodeName == null) {
            string = "" + n2;
            this.pile.push(string);
            this.saveLine(this.lineTab("\"" + string + "\"" + "[label=\"" + string + "\", shape=circle, color=blue, style=filled]"));
        } else {
            string = this.currentNodeName;
            this.pile.push(string);
            this.saveLine(this.lineTab("\"" + string + "\"" + "[label=\"" + n2 + "\", shape=circle, color=blue, style=filled]"));
        }
        this.currentNodeName = string;
    }

    public final void propagating(int n, IConstr iConstr) {
        String string = this.currentNodeName + "." + n;
        if (this.currentNodeName == null) {
            this.saveLine(this.lineTab("\"null\" [label=\"\", shape=point]"));
        }
        String string2 = this.estOrange ? "orange" : "green";
        this.saveLine(this.lineTab("\"" + string + "\"" + "[label=\"" + Integer.toString(n) + "\",shape=point, color=black]"));
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\"" + " -- " + "\"" + string + "\"" + "[label=" + "\" " + Integer.toString(n) + "\", fontcolor =" + string2 + ", color = " + string2 + ", style = bold]"));
        this.currentNodeName = string;
        this.estOrange = false;
    }

    public final void backtracking(int n) {
        String string = this.pile.last();
        this.pile.pop();
        this.saveLine("\"" + string + "\"" + "--" + "\"" + this.currentNodeName + "\"" + "[label=\"\", color=red, style=dotted]");
        this.currentNodeName = string;
    }

    public final void adding(int n) {
        this.estOrange = true;
    }

    public final void learn(IConstr iConstr) {
    }

    public final void delete(int[] nArray) {
    }

    public final void conflictFound(IConstr iConstr) {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"red\", style=filled]"));
    }

    public final void conflictFound(int n) {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"red\", style=filled]"));
    }

    public final void solutionFound() {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"green\", style=filled]"));
    }

    public final void beginLoop() {
    }

    public final void start() {
        this.saveLine("graph G {");
    }

    public final void end(Lbool lbool) {
        this.saveLine("}");
    }

    private final String lineTab(String string) {
        return "\t" + string;
    }

    private final void saveLine(String string) {
        try {
            this.out.write(string + '\n');
            if ("}".equals(string)) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.out = new PrintWriter(System.out);
    }
}

