/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Clauses;
import org.sat4j.minisat.core.Constr;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public abstract class AbstractPBClauseCardConstrDataStructure
extends AbstractPBDataStructureFactory {
    private static final long serialVersionUID = 1L;
    static final BigInteger MAX_INT_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Constr constraintFactory(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        if (bigInteger.equals(BigInteger.ONE)) {
            IVecInt iVecInt = Clauses.sanityCheck(new VecInt(nArray), this.getVocabulary(), this.solver);
            if (iVecInt == null) {
                return null;
            }
            return this.constructClause(iVecInt);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(bigIntegerArray)) {
            if (!$assertionsDisabled && bigInteger.compareTo(MAX_INT_VALUE) >= 0) {
                throw new AssertionError();
            }
            return this.constructCard(new VecInt(nArray), bigInteger.intValue());
        }
        return this.constructPB(nArray, bigIntegerArray, bigInteger);
    }

    protected Constr learntConstraintFactory(IDataStructurePB iDataStructurePB) {
        if (iDataStructurePB.getDegree().equals(BigInteger.ONE)) {
            return this.constructLearntClause(iDataStructurePB);
        }
        if (iDataStructurePB.isCardinality()) {
            return this.constructLearntCard(iDataStructurePB);
        }
        return this.constructLearntPB(iDataStructurePB);
    }

    static boolean coefficientsEqualToOne(BigInteger[] bigIntegerArray) {
        for (int i = 0; i < bigIntegerArray.length; ++i) {
            if (bigIntegerArray[i].equals(BigInteger.ONE)) continue;
            return false;
        }
        return true;
    }

    protected abstract Constr constructClause(IVecInt var1);

    protected abstract Constr constructCard(IVecInt var1, int var2) throws ContradictionException;

    protected abstract Constr constructPB(int[] var1, BigInteger[] var2, BigInteger var3) throws ContradictionException;

    protected abstract Constr constructLearntClause(IDataStructurePB var1);

    protected abstract Constr constructLearntCard(IDataStructurePB var1);

    protected abstract Constr constructLearntPB(IDataStructurePB var1);

    static {
        $assertionsDisabled = !AbstractPBClauseCardConstrDataStructure.class.desiredAssertionStatus();
        MAX_INT_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    }
}

