/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.tools.DisjunctionRHS;
import org.sat4j.pb.tools.INegator;
import org.sat4j.pb.tools.ImplicationNamer;
import org.sat4j.pb.tools.ImplicationRHS;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.pb.tools.XplainPB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.GateTranslator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyHelper<T, C> {
    public final INegator<T> NO_NEGATION = new INegator<T>(){

        @Override
        public boolean isNegated(T t) {
            return false;
        }

        @Override
        public T unNegate(T t) {
            return t;
        }
    };
    private static final long serialVersionUID = 1L;
    private final Map<T, Integer> mapToDimacs = new HashMap<T, Integer>();
    private final Map<Integer, T> mapToDomain = new HashMap<Integer, T>();
    final Map<IConstr, C> descs = new HashMap<IConstr, C>();
    final XplainPB xplain;
    private final GateTranslator gator;
    private INegator<T> negator = this.NO_NEGATION;

    public DependencyHelper(IPBSolver iPBSolver) {
        this.xplain = new XplainPB(iPBSolver);
        this.gator = new GateTranslator(this.xplain);
    }

    public void setNegator(INegator<T> iNegator) {
        this.negator = iNegator;
    }

    int getIntValue(T t) {
        boolean bl = this.negator.isNegated(t);
        T t2 = bl ? this.negator.unNegate(t) : t;
        Integer n = this.mapToDimacs.get(t2);
        if (n == null) {
            n = new Integer(this.xplain.nextFreeVarId(true));
            this.mapToDomain.put(n, t);
            this.mapToDimacs.put(t, n);
        }
        if (bl) {
            return -n.intValue();
        }
        return n;
    }

    public IVec<T> getSolution() {
        int[] nArray = this.xplain.model();
        Vec<T> vec = new Vec<T>();
        for (int n : nArray) {
            if (n <= 0) continue;
            vec.push(this.mapToDomain.get(new Integer(n)));
        }
        return vec;
    }

    public boolean getBooleanValueFor(T t) {
        return this.xplain.model(this.getIntValue(t));
    }

    public boolean hasASolution() throws TimeoutException {
        return this.xplain.isSatisfiable();
    }

    public boolean hasASolution(IVec<T> iVec) throws TimeoutException {
        VecInt vecInt = new VecInt();
        Iterator<T> iterator = iVec.iterator();
        while (iterator.hasNext()) {
            vecInt.push(this.getIntValue(iterator.next()));
        }
        return this.xplain.isSatisfiable(vecInt);
    }

    public boolean hasASolution(Collection<T> collection) throws TimeoutException {
        VecInt vecInt = new VecInt();
        for (T t : collection) {
            vecInt.push(this.getIntValue(t));
        }
        return this.xplain.isSatisfiable(vecInt);
    }

    public Set<C> why() throws TimeoutException {
        Collection<IConstr> collection = this.xplain.explain();
        TreeSet<C> treeSet = new TreeSet<C>();
        for (IConstr iConstr : collection) {
            C c = this.descs.get(iConstr);
            if (c == null) continue;
            treeSet.add(c);
        }
        return treeSet;
    }

    public Set<C> why(T t) throws TimeoutException {
        VecInt vecInt = new VecInt();
        vecInt.push(-this.getIntValue(t));
        return this.why(vecInt);
    }

    public Set<C> whyNot(T t) throws TimeoutException {
        VecInt vecInt = new VecInt();
        vecInt.push(this.getIntValue(t));
        return this.why(vecInt);
    }

    private Set<C> why(IVecInt iVecInt) throws TimeoutException {
        if (this.xplain.isSatisfiable(iVecInt)) {
            return Collections.emptySet();
        }
        return this.why();
    }

    public void setTrue(T t, C c) throws ContradictionException {
        this.descs.put(this.gator.gateTrue(this.getIntValue(t)), c);
    }

    public void setFalse(T t, C c) throws ContradictionException {
        this.descs.put(this.gator.gateFalse(this.getIntValue(t)), c);
    }

    public ImplicationRHS<T, C> implication(T[] TArray) {
        VecInt vecInt = new VecInt();
        for (T t : TArray) {
            vecInt.push(-this.getIntValue(t));
        }
        return new ImplicationRHS(this, vecInt);
    }

    public DisjunctionRHS<T, C> disjunction(T[] TArray) {
        VecInt vecInt = new VecInt();
        for (T t : TArray) {
            vecInt.push(-this.getIntValue(t));
        }
        return new DisjunctionRHS(this, vecInt);
    }

    public ImplicationNamer<T, C> atMost(int n, T[] TArray) throws ContradictionException {
        Vec<IConstr> vec = new Vec<IConstr>();
        VecInt vecInt = new VecInt();
        for (T t : TArray) {
            vecInt.push(this.getIntValue(t));
        }
        vec.push(this.xplain.addAtMost(vecInt, n));
        return new ImplicationNamer(this, vec);
    }

    public void iff(C c, T t, T[] TArray) throws ContradictionException {
        VecInt vecInt = new VecInt(TArray.length);
        Object[] objectArray = TArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            T t2 = objectArray[i];
            vecInt.push(this.getIntValue(t2));
        }
        for (T t3 : objectArray = this.gator.iff(this.getIntValue(t), vecInt)) {
            this.descs.put((IConstr)t3, c);
        }
    }

    public void and(C c, T t, T[] TArray) throws ContradictionException {
        VecInt vecInt = new VecInt(TArray.length);
        Object[] objectArray = TArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            T t2 = objectArray[i];
            vecInt.push(this.getIntValue(t2));
        }
        for (T t3 : objectArray = this.gator.and(this.getIntValue(t), vecInt)) {
            this.descs.put((IConstr)t3, c);
        }
    }

    public void or(C c, T t, T[] TArray) throws ContradictionException {
        VecInt vecInt = new VecInt(TArray.length);
        Object[] objectArray = TArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            T t2 = objectArray[i];
            vecInt.push(this.getIntValue(t2));
        }
        for (T t3 : objectArray = this.gator.or(this.getIntValue(t), vecInt)) {
            this.descs.put((IConstr)t3, c);
        }
    }

    public void ifThenElse(C c, T t, T t2, T t3, T t4) throws ContradictionException {
        IConstr[] iConstrArray;
        for (IConstr iConstr : iConstrArray = this.gator.ite(this.getIntValue(t), this.getIntValue(t2), this.getIntValue(t3), this.getIntValue(t4))) {
            this.descs.put(iConstr, c);
        }
    }

    public void setObjectiveFunction(WeightedObject<T>[] weightedObjectArray) {
        VecInt vecInt = new VecInt(weightedObjectArray.length);
        Vec<BigInteger> vec = new Vec<BigInteger>(weightedObjectArray.length);
        for (WeightedObject<T> weightedObject : weightedObjectArray) {
            vecInt.push(this.getIntValue(weightedObject.thing));
            vec.push(weightedObject.getWeight());
        }
        ObjectiveFunction objectiveFunction = new ObjectiveFunction(vecInt, vec);
        this.xplain.setObjectiveFunction(objectiveFunction);
    }

    public void stopSolver() {
        this.xplain.expireTimeout();
    }

    public void stopExplanation() {
        this.xplain.cancelExplanation();
    }
}

