/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Solver;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedMaxSatDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    public static final BigInteger SAT4J_MAX_BIG_INTEGER;
    private static final long serialVersionUID = 1L;
    protected int nborigvars;
    private int nbexpectedclauses;
    private BigInteger falsifiedWeight = BigInteger.ZERO;
    protected int nbnewvar;
    protected int[] prevmodel;
    protected boolean[] prevboolmodel;
    protected int[] prevfullmodel;
    private IConstr previousPBConstr;
    protected BigInteger top = SAT4J_MAX_BIG_INTEGER;
    private BigInteger counter;
    private final IVecInt lits = new VecInt();
    private final IVec<BigInteger> coefs = new Vec();
    private final ObjectiveFunction obj = new ObjectiveFunction(this.lits, this.coefs);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$maxsat$WeightedMaxSatDecorator;

    public WeightedMaxSatDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
        IOrder iOrder = ((Solver)iPBSolver).getOrder();
        if (iOrder instanceof VarOrderHeapObjective) {
            ((VarOrderHeapObjective)iOrder).setObjectiveFunction(this.obj);
        }
    }

    public int newVar(int n) {
        this.nborigvars = super.newVar(n);
        return this.nborigvars;
    }

    public void setExpectedNumberOfClauses(int n) {
        this.nbexpectedclauses = n;
        this.lits.ensure(n);
        this.falsifiedWeight = BigInteger.ZERO;
        super.setExpectedNumberOfClauses(n);
        super.newVar(this.nborigvars + this.nbexpectedclauses);
    }

    public int[] model() {
        return this.prevmodel;
    }

    public boolean model(int n) {
        return this.prevboolmodel[n - 1];
    }

    public void setTopWeight(BigInteger bigInteger) {
        this.top = bigInteger;
    }

    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        int n = iVecInt.get(0);
        iVecInt.delete(0);
        return this.addSoftClause(n, iVecInt);
    }

    public IConstr addHardClause(IVecInt iVecInt) throws ContradictionException {
        return super.addClause(iVecInt);
    }

    public IConstr addSoftClause(IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(1, iVecInt);
    }

    public IConstr addSoftClause(int n, IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(BigInteger.valueOf(n), iVecInt);
    }

    public IConstr addSoftClause(BigInteger bigInteger, IVecInt iVecInt) throws ContradictionException {
        if (bigInteger.compareTo(this.top) < 0) {
            if (iVecInt.size() == 1) {
                int n = -iVecInt.get(0);
                int n2 = this.lits.containsAt(n);
                if (n2 != -1) {
                    this.coefs.set(n2, (Object)((BigInteger)this.coefs.get(n2)).add(bigInteger));
                } else {
                    n2 = this.lits.containsAt(-n);
                    if (n2 != -1) {
                        this.falsifiedWeight = this.falsifiedWeight.add(bigInteger);
                        BigInteger bigInteger2 = (BigInteger)this.coefs.get(n2);
                        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger);
                        if (bigInteger3.signum() > 0) {
                            this.coefs.set(n2, (Object)bigInteger3);
                        } else if (bigInteger3.signum() < 0) {
                            this.lits.set(n2, n);
                            this.coefs.set(n2, (Object)bigInteger3.abs());
                            this.falsifiedWeight = this.falsifiedWeight.add(bigInteger3);
                        } else {
                            if (!$assertionsDisabled && bigInteger3.signum() != 0) {
                                throw new AssertionError();
                            }
                            this.lits.delete(n2);
                            this.coefs.delete(n2);
                        }
                    } else {
                        this.lits.push(n);
                        this.coefs.push((Object)bigInteger);
                    }
                }
                return null;
            }
            this.coefs.push((Object)bigInteger);
            int n = this.nborigvars + ++this.nbnewvar;
            iVecInt.push(n);
            this.lits.push(n);
        }
        return super.addClause(iVecInt);
    }

    public void addLiteralsToMinimize(IVecInt iVecInt) {
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            this.lits.push(iteratorInt.next());
            this.coefs.push((Object)BigInteger.ONE);
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt iVecInt, IVec<BigInteger> iVec) {
        if (iVecInt.size() != this.coefs.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < iVecInt.size(); ++i) {
            this.lits.push(iVecInt.get(i));
            this.coefs.push(iVec.get(i));
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt iVecInt, IVecInt iVecInt2) {
        if (iVecInt.size() != iVecInt2.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < iVecInt.size(); ++i) {
            this.lits.push(iVecInt.get(i));
            this.coefs.push((Object)BigInteger.valueOf(iVecInt2.get(i)));
        }
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        boolean bl = super.isSatisfiable(iVecInt, true);
        if (bl) {
            int n;
            int n2;
            this.prevboolmodel = new boolean[this.nVars()];
            for (n2 = 0; n2 < this.nVars(); ++n2) {
                this.prevboolmodel[n2] = ((IPBSolver)this.decorated()).model(n2 + 1);
            }
            n2 = this.nborigvars + this.nbnewvar;
            if (this.prevfullmodel == null) {
                this.prevfullmodel = new int[n2];
            }
            for (n = 1; n <= n2; ++n) {
                this.prevfullmodel[n - 1] = super.model(n) ? n : -n;
            }
            this.prevmodel = new int[this.nborigvars];
            for (n = 0; n < this.nborigvars; ++n) {
                this.prevmodel[n] = this.prevfullmodel[n];
            }
            this.calculateObjective();
        }
        return bl;
    }

    public void reset() {
        this.coefs.clear();
        this.lits.clear();
        this.nbnewvar = 0;
        this.previousPBConstr = null;
        super.reset();
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    public Number calculateObjective() {
        this.counter = BigInteger.ZERO;
        for (int n : this.prevfullmodel) {
            int n2 = this.lits.containsAt(n);
            if (n2 == -1) continue;
            this.counter = this.counter.add((BigInteger)this.coefs.get(n2));
        }
        return this.falsifiedWeight.add(this.counter);
    }

    public void discardCurrentSolution() throws ContradictionException {
        if (!$assertionsDisabled && this.lits.size() != this.coefs.size()) {
            throw new AssertionError();
        }
        if (this.previousPBConstr != null) {
            this.removeSubsumedConstr(this.previousPBConstr);
        }
        this.previousPBConstr = super.addPseudoBoolean(this.lits, this.coefs, false, this.counter.add(BigInteger.ONE.negate()));
    }

    public Number getObjectiveValue() {
        return this.falsifiedWeight.add(this.counter);
    }

    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$maxsat$WeightedMaxSatDecorator == null ? (class$org$sat4j$maxsat$WeightedMaxSatDecorator = WeightedMaxSatDecorator.class$("org.sat4j.maxsat.WeightedMaxSatDecorator")) : class$org$sat4j$maxsat$WeightedMaxSatDecorator).desiredAssertionStatus();
        SAT4J_MAX_BIG_INTEGER = new BigInteger("100000000000000000000000000000000000000000");
    }
}

