/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.maxsat.UnitWeightedClause;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedMaxSatDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    public static final BigInteger SAT4J_MAX_BIG_INTEGER;
    private static final long serialVersionUID = 1L;
    protected int nborigvars;
    private int nbexpectedclauses;
    private BigInteger falsifiedWeight = BigInteger.ZERO;
    protected int nbnewvar;
    protected int[] prevmodel;
    protected boolean[] prevboolmodel;
    protected int[] prevfullmodel;
    private IConstr previousPBConstr;
    private boolean isSolutionOptimal;
    protected BigInteger top = SAT4J_MAX_BIG_INTEGER;
    private BigInteger counter;
    private final IVecInt lits = new VecInt();
    private final IVec<BigInteger> coefs = new Vec<BigInteger>();
    private final ObjectiveFunction obj = new ObjectiveFunction(this.lits, this.coefs);
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.maxsat.WeightedMaxSatDecorator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        SAT4J_MAX_BIG_INTEGER = new BigInteger("100000000000000000000000000000000000000000");
    }

    public WeightedMaxSatDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
        iPBSolver.setObjectiveFunction(this.obj);
    }

    @Override
    public int newVar(int n) {
        this.nborigvars = super.newVar(n);
        return this.nborigvars;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.nbexpectedclauses = n;
        this.lits.ensure(n);
        this.falsifiedWeight = BigInteger.ZERO;
        super.setExpectedNumberOfClauses(n);
        super.newVar(this.nborigvars + this.nbexpectedclauses);
    }

    @Override
    public int[] model() {
        return this.prevmodel;
    }

    @Override
    public boolean model(int n) {
        return this.prevboolmodel[n - 1];
    }

    public void setTopWeight(BigInteger bigInteger) {
        this.top = bigInteger;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        int n = iVecInt.get(0);
        iVecInt.delete(0);
        return this.addSoftClause(n, iVecInt);
    }

    public IConstr addHardClause(IVecInt iVecInt) throws ContradictionException {
        return super.addClause(iVecInt);
    }

    public IConstr addSoftClause(IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(1, iVecInt);
    }

    public IConstr addSoftClause(int n, IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(BigInteger.valueOf(n), iVecInt);
    }

    public IConstr addSoftClause(BigInteger bigInteger, IVecInt iVecInt) throws ContradictionException {
        if (bigInteger.compareTo(this.top) < 0) {
            if (iVecInt.size() == 1) {
                int n = -iVecInt.get(0);
                int n2 = this.lits.containsAt(n);
                if (n2 != -1) {
                    this.coefs.set(n2, this.coefs.get(n2).add(bigInteger));
                } else {
                    n2 = this.lits.containsAt(-n);
                    if (n2 != -1) {
                        this.falsifiedWeight = this.falsifiedWeight.add(bigInteger);
                        BigInteger bigInteger2 = this.coefs.get(n2);
                        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger);
                        if (bigInteger3.signum() > 0) {
                            this.coefs.set(n2, bigInteger3);
                        } else if (bigInteger3.signum() < 0) {
                            this.lits.set(n2, n);
                            this.coefs.set(n2, bigInteger3.abs());
                            this.falsifiedWeight = this.falsifiedWeight.add(bigInteger3);
                        } else {
                            if (!$assertionsDisabled && bigInteger3.signum() != 0) {
                                throw new AssertionError();
                            }
                            this.lits.delete(n2);
                            this.coefs.delete(n2);
                        }
                    } else {
                        this.lits.push(n);
                        this.coefs.push(bigInteger);
                    }
                }
                return new UnitWeightedClause();
            }
            this.coefs.push(bigInteger);
            int n = this.nborigvars + ++this.nbnewvar;
            iVecInt.push(n);
            this.lits.push(n);
        }
        return super.addClause(iVecInt);
    }

    public void addLiteralsToMinimize(IVecInt iVecInt) {
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            this.lits.push(iteratorInt.next());
            this.coefs.push(BigInteger.ONE);
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt iVecInt, IVec<BigInteger> iVec) {
        if (iVecInt.size() != this.coefs.size()) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < iVecInt.size()) {
            this.lits.push(iVecInt.get(n));
            this.coefs.push(iVec.get(n));
            ++n;
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt iVecInt, IVecInt iVecInt2) {
        if (iVecInt.size() != iVecInt2.size()) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < iVecInt.size()) {
            this.lits.push(iVecInt.get(n));
            this.coefs.push(BigInteger.valueOf(iVecInt2.get(n)));
            ++n;
        }
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    @Override
    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        this.isSolutionOptimal = false;
        boolean bl = super.isSatisfiable(iVecInt, true);
        if (bl) {
            this.prevboolmodel = new boolean[this.nVars()];
            int n = 0;
            while (n < this.nVars()) {
                this.prevboolmodel[n] = ((IPBSolver)this.decorated()).model(n + 1);
                ++n;
            }
            n = this.nborigvars + this.nbnewvar;
            if (this.prevfullmodel == null) {
                this.prevfullmodel = new int[n];
            }
            int n2 = 1;
            while (n2 <= n) {
                this.prevfullmodel[n2 - 1] = super.model(n2) ? n2 : -n2;
                ++n2;
            }
            this.prevmodel = new int[this.nborigvars];
            n2 = 0;
            while (n2 < this.nborigvars) {
                this.prevmodel[n2] = this.prevfullmodel[n2];
                ++n2;
            }
            this.calculateObjective();
        } else {
            this.isSolutionOptimal = true;
            if (this.previousPBConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                this.previousPBConstr = null;
            }
        }
        return bl;
    }

    @Override
    public void reset() {
        this.coefs.clear();
        this.lits.clear();
        this.nbnewvar = 0;
        this.previousPBConstr = null;
        super.reset();
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    @Override
    public Number calculateObjective() {
        this.counter = BigInteger.ZERO;
        int[] nArray = this.prevfullmodel;
        int n = this.prevfullmodel.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            int n4 = this.lits.containsAt(n3);
            if (n4 != -1) {
                this.counter = this.counter.add(this.coefs.get(n4));
            }
            ++n2;
        }
        return this.falsifiedWeight.add(this.counter);
    }

    @Override
    public void discardCurrentSolution() throws ContradictionException {
        if (!$assertionsDisabled && this.lits.size() != this.coefs.size()) {
            throw new AssertionError();
        }
        if (this.previousPBConstr != null) {
            this.removeSubsumedConstr(this.previousPBConstr);
        }
        try {
            this.previousPBConstr = super.addPseudoBoolean(this.lits, this.coefs, false, this.counter.add(BigInteger.ONE.negate()));
        }
        catch (ContradictionException contradictionException) {
            this.isSolutionOptimal = true;
            throw contradictionException;
        }
    }

    @Override
    public Number getObjectiveValue() {
        return this.falsifiedWeight.add(this.counter);
    }

    @Override
    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    @Override
    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        super.addPseudoBoolean(this.lits, this.coefs, false, (BigInteger)number);
    }

    @Override
    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }
}

