/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.io.PrintWriter;
import java.util.Random;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;

public final class RandomWalkDecorator
implements IOrder {
    private final IOrder decorated;
    private final double p;
    private final Random rand = new Random();
    private ILits voc;
    private int nbRandomWalks;

    public RandomWalkDecorator(IOrder iOrder) {
        this(iOrder, 0.01);
    }

    public RandomWalkDecorator(IOrder iOrder, double d) {
        this.decorated = iOrder;
        this.p = d;
    }

    public void assignLiteral(int n) {
        this.decorated.assignLiteral(n);
    }

    public IPhaseSelectionStrategy getPhaseSelectionStrategy() {
        return this.decorated.getPhaseSelectionStrategy();
    }

    public void init() {
        this.decorated.init();
        this.nbRandomWalks = 0;
    }

    public void printStat(PrintWriter printWriter, String string) {
        printWriter.println(String.valueOf(string) + "random Assignements: " + this.nbRandomWalks);
        this.decorated.printStat(printWriter, string);
    }

    public int select() {
        if (this.rand.nextDouble() < this.p) {
            int n = this.voc.nVars() << 1;
            int n2 = 0;
            while (n2 <= 10) {
                int n3 = this.rand.nextInt(n) + 2;
                if (this.voc.isUnassigned(n3)) {
                    ++this.nbRandomWalks;
                    return this.getPhaseSelectionStrategy().select(n3 >> 1);
                }
                ++n2;
            }
        }
        return this.decorated.select();
    }

    public void setLits(ILits iLits) {
        this.decorated.setLits(iLits);
        this.voc = iLits;
    }

    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        this.decorated.setPhaseSelectionStrategy(iPhaseSelectionStrategy);
    }

    public void setVarDecay(double d) {
        this.decorated.setVarDecay(d);
    }

    public void undo(int n) {
        this.decorated.undo(n);
    }

    public void updateVar(int n) {
        this.decorated.updateVar(n);
    }

    public double varActivity(int n) {
        return this.decorated.varActivity(n);
    }

    public void varDecayActivity() {
        this.decorated.varDecayActivity();
    }

    public void updateVarAtDecisionLevel(int n) {
        this.decorated.updateVarAtDecisionLevel(n);
    }

    public String toString() {
        return String.valueOf(this.decorated.toString()) + " with random walks " + this.p;
    }
}

