/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.xplain.HighLevelXplain;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedCNFReader
extends DimacsReader {
    private static final long serialVersionUID = 1L;
    private int numberOfComponents;
    private final HighLevelXplain<ISolver> hlxplain;
    private int currentComponentIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.reader.GroupedCNFReader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GroupedCNFReader(HighLevelXplain<ISolver> highLevelXplain) {
        super(highLevelXplain, "gcnf");
        this.hlxplain = highLevelXplain;
    }

    @Override
    protected void readProblemLine() throws IOException, ParseFormatException {
        String string = this.scanner.nextLine().trim();
        if (string == null) {
            throw new ParseFormatException(new StringBuffer("premature end of file: <p ").append(this.formatString).append(" ...> expected").toString());
        }
        String[] stringArray = string.split("\\s+");
        if (stringArray.length < 5 || !"p".equals(stringArray[0]) || !this.formatString.equals(stringArray[1])) {
            throw new ParseFormatException(new StringBuffer("problem line expected (p ").append(this.formatString).append(" ...)").toString());
        }
        int n = Integer.parseInt(stringArray[2]);
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        this.solver.newVar(n);
        this.expectedNbOfConstr = Integer.parseInt(stringArray[3]);
        if (!$assertionsDisabled && this.expectedNbOfConstr <= 0) {
            throw new AssertionError();
        }
        this.numberOfComponents = Integer.parseInt(stringArray[4]);
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean handleLine() throws ContradictionException, IOException, ParseFormatException {
        var2_1 = false;
        var3_2 = this.scanner.next();
        if (!var3_2.startsWith("{") || !var3_2.endsWith("}")) {
            throw new ParseFormatException("Component index required at the beginning of the clause");
        }
        this.currentComponentIndex = Integer.valueOf(var3_2.substring(1, var3_2.length() - 1));
        if (this.currentComponentIndex >= 0 && this.currentComponentIndex <= this.numberOfComponents) ** GOTO lbl17
        throw new ParseFormatException(new StringBuffer("wrong component index: ").append(this.currentComponentIndex).toString());
lbl-1000:
        // 1 sources

        {
            var1_3 = this.scanner.nextInt();
            if (var1_3 == 0) {
                if (this.literals.size() <= 0) break;
                this.flushConstraint();
                this.literals.clear();
                var2_1 = true;
                break;
            }
            this.literals.push(var1_3);
lbl17:
            // 2 sources

            ** while (!this.scanner.eof())
        }
lbl18:
        // 3 sources

        return var2_1;
    }

    @Override
    protected void flushConstraint() throws ContradictionException {
        block4: {
            try {
                if (this.currentComponentIndex == 0) {
                    this.hlxplain.addClause(this.literals);
                } else {
                    this.hlxplain.addClause(this.literals, this.currentComponentIndex);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!this.isVerbose()) break block4;
                System.err.println(new StringBuffer("c Skipping constraint ").append(this.literals).toString());
            }
        }
    }
}

