/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.maxsat.UnitWeightedClause;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedMaxSatDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    public static final BigInteger SAT4J_MAX_BIG_INTEGER;
    private static final long serialVersionUID = 1L;
    protected int nborigvars;
    private int nbexpectedclauses;
    private BigInteger falsifiedWeight = BigInteger.ZERO;
    protected int nbnewvar;
    protected int[] prevmodel;
    protected boolean[] prevboolmodel;
    protected int[] prevfullmodel;
    private IConstr previousPBConstr;
    private boolean isSolutionOptimal;
    protected BigInteger top = SAT4J_MAX_BIG_INTEGER;
    private BigInteger counter;
    private final IVecInt lits = new VecInt();
    private final IVec<BigInteger> coefs = new Vec<BigInteger>();
    private final ObjectiveFunction obj = new ObjectiveFunction(this.lits, this.coefs);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$maxsat$WeightedMaxSatDecorator;

    public WeightedMaxSatDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
        iPBSolver.setObjectiveFunction(this.obj);
    }

    @Override
    public int newVar(int n) {
        this.nborigvars = super.newVar(n);
        return this.nborigvars;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.nbexpectedclauses = n;
        this.lits.ensure(n);
        this.falsifiedWeight = BigInteger.ZERO;
        super.setExpectedNumberOfClauses(n);
        super.newVar(this.nborigvars + this.nbexpectedclauses);
    }

    @Override
    public int[] model() {
        return this.prevmodel;
    }

    @Override
    public boolean model(int n) {
        return this.prevboolmodel[n - 1];
    }

    public void setTopWeight(BigInteger bigInteger) {
        this.top = bigInteger;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        int n = iVecInt.get(0);
        iVecInt.delete(0);
        return this.addSoftClause(n, iVecInt);
    }

    public IConstr addHardClause(IVecInt iVecInt) throws ContradictionException {
        return super.addClause(iVecInt);
    }

    public IConstr addSoftClause(IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(1, iVecInt);
    }

    public IConstr addSoftClause(int n, IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(BigInteger.valueOf(n), iVecInt);
    }

    public IConstr addSoftClause(BigInteger bigInteger, IVecInt iVecInt) throws ContradictionException {
        if (bigInteger.compareTo(this.top) < 0) {
            if (iVecInt.size() == 1) {
                int n = -iVecInt.get(0);
                int n2 = this.lits.containsAt(n);
                if (n2 != -1) {
                    this.coefs.set(n2, this.coefs.get(n2).add(bigInteger));
                } else {
                    n2 = this.lits.containsAt(-n);
                    if (n2 != -1) {
                        this.falsifiedWeight = this.falsifiedWeight.add(bigInteger);
                        BigInteger bigInteger2 = this.coefs.get(n2);
                        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger);
                        if (bigInteger3.signum() > 0) {
                            this.coefs.set(n2, bigInteger3);
                        } else if (bigInteger3.signum() < 0) {
                            this.lits.set(n2, n);
                            this.coefs.set(n2, bigInteger3.abs());
                            this.falsifiedWeight = this.falsifiedWeight.add(bigInteger3);
                        } else {
                            if (!$assertionsDisabled && bigInteger3.signum() != 0) {
                                throw new AssertionError();
                            }
                            this.lits.delete(n2);
                            this.coefs.delete(n2);
                        }
                    } else {
                        this.lits.push(n);
                        this.coefs.push(bigInteger);
                    }
                }
                return new UnitWeightedClause();
            }
            this.coefs.push(bigInteger);
            int n = this.nborigvars + ++this.nbnewvar;
            iVecInt.push(n);
            this.lits.push(n);
        }
        return super.addClause(iVecInt);
    }

    public IConstr addSoftAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        return this.addSoftAtLeast(BigInteger.ONE, iVecInt, n);
    }

    public IConstr addSoftAtLeast(int n, IVecInt iVecInt, int n2) throws ContradictionException {
        return this.addSoftAtLeast(BigInteger.valueOf(n), iVecInt, n2);
    }

    public IConstr addSoftAtLeast(BigInteger bigInteger, IVecInt iVecInt, int n) throws ContradictionException {
        if (bigInteger.compareTo(this.top) < 0) {
            this.coefs.push(bigInteger);
            int n2 = this.nborigvars + ++this.nbnewvar;
            this.lits.push(n2);
            Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt.size() + 1);
            vec.growTo(iVecInt.size(), BigInteger.ONE);
            iVecInt.push(n2);
            BigInteger bigInteger2 = BigInteger.valueOf(n);
            vec.push(bigInteger2);
            return this.addPseudoBoolean(iVecInt, vec, true, bigInteger2);
        }
        return this.addAtLeast(iVecInt, n);
    }

    public IConstr addSoftAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        return this.addSoftAtMost(BigInteger.ONE, iVecInt, n);
    }

    public IConstr addSoftAtMost(int n, IVecInt iVecInt, int n2) throws ContradictionException {
        return this.addSoftAtMost(BigInteger.valueOf(n), iVecInt, n2);
    }

    public IConstr addSoftAtMost(BigInteger bigInteger, IVecInt iVecInt, int n) throws ContradictionException {
        if (bigInteger.compareTo(this.top) < 0) {
            this.coefs.push(bigInteger);
            int n2 = this.nborigvars + ++this.nbnewvar;
            this.lits.push(n2);
            Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt.size() + 1);
            vec.growTo(iVecInt.size(), BigInteger.ONE);
            iVecInt.push(n2);
            BigInteger bigInteger2 = BigInteger.valueOf(n);
            vec.push(bigInteger2.negate());
            return this.addPseudoBoolean(iVecInt, vec, true, bigInteger2);
        }
        return this.addAtMost(iVecInt, n);
    }

    public void addLiteralsToMinimize(IVecInt iVecInt) {
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            this.lits.push(iteratorInt.next());
            this.coefs.push(BigInteger.ONE);
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt iVecInt, IVec<BigInteger> iVec) {
        if (iVecInt.size() != this.coefs.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < iVecInt.size(); ++i) {
            this.lits.push(iVecInt.get(i));
            this.coefs.push(iVec.get(i));
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt iVecInt, IVecInt iVecInt2) {
        if (iVecInt.size() != iVecInt2.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < iVecInt.size(); ++i) {
            this.lits.push(iVecInt.get(i));
            this.coefs.push(BigInteger.valueOf(iVecInt2.get(i)));
        }
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    @Override
    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        this.isSolutionOptimal = false;
        boolean bl = super.isSatisfiable(iVecInt, true);
        if (bl) {
            int n;
            int n2;
            this.prevboolmodel = new boolean[this.nVars()];
            for (n2 = 0; n2 < this.nVars(); ++n2) {
                this.prevboolmodel[n2] = ((IPBSolver)this.decorated()).model(n2 + 1);
            }
            n2 = this.nborigvars + this.nbnewvar;
            if (this.prevfullmodel == null) {
                this.prevfullmodel = new int[n2];
            }
            for (n = 1; n <= n2; ++n) {
                this.prevfullmodel[n - 1] = super.model(n) ? n : -n;
            }
            this.prevmodel = new int[this.nborigvars];
            for (n = 0; n < this.nborigvars; ++n) {
                this.prevmodel[n] = this.prevfullmodel[n];
            }
            this.calculateObjective();
        } else {
            this.isSolutionOptimal = true;
            if (this.previousPBConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                this.previousPBConstr = null;
            }
        }
        return bl;
    }

    @Override
    public void reset() {
        this.coefs.clear();
        this.lits.clear();
        this.nbnewvar = 0;
        this.previousPBConstr = null;
        super.reset();
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    @Override
    public Number calculateObjective() {
        this.counter = BigInteger.ZERO;
        for (int n : this.prevfullmodel) {
            int n2 = this.lits.containsAt(n);
            if (n2 == -1) continue;
            this.counter = this.counter.add(this.coefs.get(n2));
        }
        return this.falsifiedWeight.add(this.counter);
    }

    @Override
    public void discardCurrentSolution() throws ContradictionException {
        if (!$assertionsDisabled && this.lits.size() != this.coefs.size()) {
            throw new AssertionError();
        }
        if (this.previousPBConstr != null) {
            this.removeSubsumedConstr(this.previousPBConstr);
        }
        try {
            this.previousPBConstr = super.addPseudoBoolean(this.lits, this.coefs, false, this.counter.add(BigInteger.ONE.negate()));
        }
        catch (ContradictionException contradictionException) {
            this.isSolutionOptimal = true;
            throw contradictionException;
        }
    }

    @Override
    public Number getObjectiveValue() {
        return this.falsifiedWeight.add(this.counter);
    }

    @Override
    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    @Override
    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        super.addPseudoBoolean(this.lits, this.coefs, false, (BigInteger)number);
    }

    @Override
    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$maxsat$WeightedMaxSatDecorator == null ? (class$org$sat4j$maxsat$WeightedMaxSatDecorator = WeightedMaxSatDecorator.class$("org.sat4j.maxsat.WeightedMaxSatDecorator")) : class$org$sat4j$maxsat$WeightedMaxSatDecorator).desiredAssertionStatus();
        SAT4J_MAX_BIG_INTEGER = new BigInteger("100000000000000000000000000000000000000000");
    }
}

