/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractOptimizationLauncher;
import org.sat4j.maxsat.MinCostDecorator;
import org.sat4j.maxsat.SolverFactory;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.reader.WDimacsReader;
import org.sat4j.opt.MaxSatDecorator;
import org.sat4j.opt.MinOneDecorator;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

public class GenericOptLauncher
extends AbstractOptimizationLauncher {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("p", "parallel", false, "uses CP and RES pseudo-boolean solver in parallel");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("k", "kind", true, "kind of problem: minone, maxsat, etc.");
        options.addOption("i", "incomplete", false, "incomplete mode for maxsat");
        return options;
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    public void usage() {
        this.out.println("java -jar sat4j-maxsat.jar instance-name");
    }

    protected Reader createReader(ISolver iSolver, String string) {
        DimacsReader dimacsReader = string.endsWith(".wcnf") ? new WDimacsReader((WeightedMaxSatDecorator)iSolver) : new DimacsReader(iSolver);
        dimacsReader.setVerbosity(true);
        return dimacsReader;
    }

    protected String getInstanceName(String[] stringArray) {
        return stringArray[stringArray.length - 1];
    }

    protected ISolver configureSolver(String[] stringArray) {
        Object object = null;
        Options options = this.createCLIOptions();
        if (stringArray.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j-maxsat.jar", options, true);
        } else {
            try {
                String string;
                CommandLine commandLine = new PosixParser().parse(options, stringArray);
                int n = stringArray.length - 1;
                String string2 = commandLine.getOptionValue("k");
                if (string2 == null) {
                    string2 = "maxsat";
                }
                if ("minone".equalsIgnoreCase(string2)) {
                    object = new MinOneDecorator((ISolver)SolverFactory.newDefault());
                } else if ("mincost".equalsIgnoreCase(string2) || stringArray[n].endsWith(".p2cnf")) {
                    object = new MinCostDecorator(SolverFactory.newDefault());
                } else {
                    if (!$assertionsDisabled && !"maxsat".equalsIgnoreCase(string2)) {
                        throw new AssertionError();
                    }
                    object = stringArray[n].endsWith(".wcnf") ? (commandLine.hasOption("p") ? new WeightedMaxSatDecorator(org.sat4j.pb.SolverFactory.newBoth()) : new WeightedMaxSatDecorator(SolverFactory.newDefault())) : (commandLine.hasOption("p") ? new MaxSatDecorator((ISolver)org.sat4j.pb.SolverFactory.newBoth()) : new MaxSatDecorator(org.sat4j.minisat.SolverFactory.newDefault()));
                }
                if (commandLine.hasOption("i")) {
                    this.setIncomplete(true);
                }
                if ((string = commandLine.getOptionValue("t")) == null) {
                    string = commandLine.getOptionValue("T");
                    if (string != null) {
                        object.setTimeoutMs(Long.parseLong(string));
                    }
                } else {
                    object.setTimeout(Integer.parseInt(string));
                }
                this.getLogWriter().println(object.toString("c "));
            }
            catch (ParseException parseException) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("java -jar sat4jopt.jar", options, true);
            }
        }
        return object;
    }

    public static void main(String[] stringArray) {
        GenericOptLauncher genericOptLauncher = new GenericOptLauncher();
        genericOptLauncher.run(stringArray);
    }

    static {
        $assertionsDisabled = !GenericOptLauncher.class.desiredAssertionStatus();
    }
}

