/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.maxsat.UnitWeightedClause;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedMaxSatDecorator
extends PBSolverDecorator {
    public static final BigInteger SAT4J_MAX_BIG_INTEGER;
    private static final long serialVersionUID = 1L;
    private BigInteger falsifiedWeight = BigInteger.ZERO;
    protected int nbnewvar;
    protected BigInteger top = SAT4J_MAX_BIG_INTEGER;
    private final IVecInt lits = new VecInt();
    private final IVec<BigInteger> coefs = new Vec<BigInteger>();
    private final ObjectiveFunction obj = new ObjectiveFunction(this.lits, this.coefs);
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.maxsat.WeightedMaxSatDecorator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        SAT4J_MAX_BIG_INTEGER = new BigInteger("100000000000000000000000000000000000000000");
    }

    public WeightedMaxSatDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
        iPBSolver.setObjectiveFunction(this.obj);
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.lits.ensure(n);
        this.falsifiedWeight = BigInteger.ZERO;
        super.setExpectedNumberOfClauses(n);
    }

    public void setTopWeight(BigInteger bigInteger) {
        this.top = bigInteger;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(1, iVecInt);
    }

    public IConstr addHardClause(IVecInt iVecInt) throws ContradictionException {
        return super.addClause(iVecInt);
    }

    public IConstr addSoftClause(IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(1, iVecInt);
    }

    public IConstr addSoftClause(int n, IVecInt iVecInt) throws ContradictionException {
        return this.addSoftClause(BigInteger.valueOf(n), iVecInt);
    }

    public IConstr addSoftClause(BigInteger bigInteger, IVecInt iVecInt) throws ContradictionException {
        if (bigInteger.compareTo(this.top) < 0) {
            if (iVecInt.size() == 1) {
                int n = -iVecInt.get(0);
                int n2 = this.lits.containsAt(n);
                if (n2 != -1) {
                    this.coefs.set(n2, this.coefs.get(n2).add(bigInteger));
                } else {
                    n2 = this.lits.containsAt(-n);
                    if (n2 != -1) {
                        this.falsifiedWeight = this.falsifiedWeight.add(bigInteger);
                        BigInteger bigInteger2 = this.coefs.get(n2);
                        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger);
                        if (bigInteger3.signum() > 0) {
                            this.coefs.set(n2, bigInteger3);
                        } else if (bigInteger3.signum() < 0) {
                            this.lits.set(n2, n);
                            this.coefs.set(n2, bigInteger3.abs());
                            this.falsifiedWeight = this.falsifiedWeight.add(bigInteger3);
                        } else {
                            if (!$assertionsDisabled && bigInteger3.signum() != 0) {
                                throw new AssertionError();
                            }
                            this.lits.delete(n2);
                            this.coefs.delete(n2);
                        }
                        this.obj.setCorrection(this.falsifiedWeight);
                    } else {
                        this.registerLiteral(n);
                        this.lits.push(n);
                        this.coefs.push(bigInteger);
                    }
                }
                return UnitWeightedClause.instance();
            }
            this.coefs.push(bigInteger);
            int n = this.nextFreeVarId(true);
            iVecInt.push(n);
            this.lits.push(n);
        }
        return super.addClause(iVecInt);
    }

    public IConstr addSoftAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        return this.addSoftAtLeast(BigInteger.ONE, iVecInt, n);
    }

    public IConstr addSoftAtLeast(int n, IVecInt iVecInt, int n2) throws ContradictionException {
        return this.addSoftAtLeast(BigInteger.valueOf(n), iVecInt, n2);
    }

    public IConstr addSoftAtLeast(BigInteger bigInteger, IVecInt iVecInt, int n) throws ContradictionException {
        if (bigInteger.compareTo(this.top) < 0) {
            this.coefs.push(bigInteger);
            int n2 = this.nextFreeVarId(true);
            this.lits.push(n2);
            Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt.size() + 1);
            vec.growTo(iVecInt.size(), BigInteger.ONE);
            iVecInt.push(n2);
            BigInteger bigInteger2 = BigInteger.valueOf(n);
            vec.push(bigInteger2);
            return this.addPseudoBoolean(iVecInt, vec, true, bigInteger2);
        }
        return this.addAtLeast(iVecInt, n);
    }

    public IConstr addSoftAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        return this.addSoftAtMost(BigInteger.ONE, iVecInt, n);
    }

    public IConstr addSoftAtMost(int n, IVecInt iVecInt, int n2) throws ContradictionException {
        return this.addSoftAtMost(BigInteger.valueOf(n), iVecInt, n2);
    }

    public IConstr addSoftAtMost(BigInteger bigInteger, IVecInt iVecInt, int n) throws ContradictionException {
        if (bigInteger.compareTo(this.top) < 0) {
            this.coefs.push(bigInteger);
            int n2 = this.nextFreeVarId(true);
            this.lits.push(n2);
            Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt.size() + 1);
            vec.growTo(iVecInt.size(), BigInteger.ONE);
            iVecInt.push(n2);
            BigInteger bigInteger2 = BigInteger.valueOf(n);
            vec.push(bigInteger2.negate());
            return this.addPseudoBoolean(iVecInt, vec, true, bigInteger2);
        }
        return this.addAtMost(iVecInt, n);
    }

    public void addLiteralsToMinimize(IVecInt iVecInt) {
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            this.lits.push(iteratorInt.next());
            this.coefs.push(BigInteger.ONE);
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt iVecInt, IVec<BigInteger> iVec) {
        if (iVecInt.size() != this.coefs.size()) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < iVecInt.size()) {
            this.lits.push(iVecInt.get(n));
            this.coefs.push(iVec.get(n));
            ++n;
        }
    }

    public void addWeightedLiteralsToMinimize(IVecInt iVecInt, IVecInt iVecInt2) {
        if (iVecInt.size() != iVecInt2.size()) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < iVecInt.size()) {
            this.lits.push(iVecInt.get(n));
            this.coefs.push(BigInteger.valueOf(iVecInt2.get(n)));
            ++n;
        }
    }

    @Override
    public void reset() {
        this.coefs.clear();
        this.lits.clear();
        this.nbnewvar = 0;
        super.reset();
    }

    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        if (this.lits.size() > 0) {
            super.addPseudoBoolean(this.lits, this.coefs, false, (BigInteger)number);
        }
    }
}

