/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.DimacsStringSolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBStringSolver
extends DimacsStringSolver
implements IPBSolver {
    private static final String FAKE_I_CONSTR_MSG = "Fake IConstr";
    private static final long serialVersionUID = 1L;
    private int indxConstrObj;
    private int nbOfConstraints;
    private ObjectiveFunction obj;
    private boolean inserted = false;
    private static final IConstr FAKE_CONSTR;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.OPBStringSolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        FAKE_CONSTR = new IConstr(){

            public int size() {
                throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
            }

            public boolean learnt() {
                throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
            }

            public double getActivity() {
                throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
            }

            public int get(int n) {
                throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
            }

            public boolean canBePropagatedMultipleTimes() {
                throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
            }
        };
    }

    public OPBStringSolver() {
    }

    public OPBStringSolver(int n) {
        super(n);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n = iteratorInt.next();
            if (n > 0) {
                this.getOut().append(new StringBuffer("+1 x").append(n).append(" >= 1 ;\n").toString());
            } else {
                this.getOut().append(new StringBuffer("-1 x").append(-n).append(" >= 0 ;\n").toString());
            }
            ++this.nbOfConstraints;
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        return super.isSatisfiable(iVecInt, bl);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        if (bl) {
            return this.addAtLeast(iVecInt, iVec, bigInteger);
        }
        return this.addAtMost(iVecInt, iVec, bigInteger);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.obj = objectiveFunction;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        int n2 = 0;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n3 = iteratorInt.next();
            if (!$assertionsDisabled && n3 == 0) {
                throw new AssertionError();
            }
            if (n3 > 0) {
                stringBuffer.append(new StringBuffer("+1 x").append(n3).append(" ").toString());
                continue;
            }
            stringBuffer.append(new StringBuffer("-1 x").append(-n3).append(" ").toString());
            ++n2;
        }
        stringBuffer.append(new StringBuffer(">= ").append(n - n2).append(" ;\n").toString());
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        int n2 = 0;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n3 = iteratorInt.next();
            if (!$assertionsDisabled && n3 == 0) {
                throw new AssertionError();
            }
            if (n3 > 0) {
                stringBuffer.append(new StringBuffer("-1 x").append(n3).append(" ").toString());
                continue;
            }
            stringBuffer.append(new StringBuffer("+1 x").append(-n3).append(" ").toString());
            ++n2;
        }
        stringBuffer.append(new StringBuffer(">= ").append(-n + n2).append(" ;\n").toString());
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n = iteratorInt.next();
            if (n > 0) {
                stringBuffer.append(new StringBuffer("+1 x").append(n).append(" ").toString());
                continue;
            }
            stringBuffer.append(new StringBuffer("+1 ~x").append(-n).append(" ").toString());
        }
        stringBuffer.append(">= 1 ;\n");
        return FAKE_CONSTR;
    }

    public String getExplanation() {
        return null;
    }

    public void setListOfVariablesForExplanation(IVecInt iVecInt) {
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = this.getOut();
        if (!this.inserted) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("* #variable= ");
            stringBuffer2.append(this.nVars());
            stringBuffer2.append(" #constraint= ");
            stringBuffer2.append(this.nbOfConstraints);
            if (this.obj != null) {
                stringBuffer2.append("\n");
                stringBuffer2.append("min: ");
                stringBuffer2.append(this.obj);
                stringBuffer2.append(";");
            }
            stringBuffer.insert(this.indxConstrObj, stringBuffer2.toString());
            this.inserted = true;
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString(String string) {
        return "OPB output solver";
    }

    @Override
    public int newVar(int n) {
        StringBuffer stringBuffer = this.getOut();
        this.setNbVars(n);
        this.indxConstrObj = stringBuffer.length();
        stringBuffer.append("\n");
        return n;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.obj;
    }

    @Override
    public int nConstraints() {
        return this.nbOfConstraints;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        if (!$assertionsDisabled && iVecInt.size() != iVecInt2.size()) {
            throw new AssertionError();
        }
        ++this.nbOfConstraints;
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            stringBuffer.append(-iVecInt2.get(n2));
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n2));
            stringBuffer.append(" ");
            ++n2;
        }
        stringBuffer.append(">= ");
        stringBuffer.append(-n);
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        ++this.nbOfConstraints;
        int n = 0;
        while (n < iVecInt.size()) {
            stringBuffer.append(iVec.get(n).negate());
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n));
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append(">= ");
        stringBuffer.append(bigInteger.negate());
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        if (!$assertionsDisabled && iVecInt.size() != iVecInt2.size()) {
            throw new AssertionError();
        }
        ++this.nbOfConstraints;
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            stringBuffer.append(iVecInt2.get(n2));
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n2));
            stringBuffer.append(" ");
            ++n2;
        }
        stringBuffer.append(">= ");
        stringBuffer.append(n);
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        ++this.nbOfConstraints;
        int n = 0;
        while (n < iVecInt.size()) {
            stringBuffer.append(iVec.get(n));
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n));
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append(">= ");
        stringBuffer.append(bigInteger);
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        if (!$assertionsDisabled && iVecInt.size() != iVecInt2.size()) {
            throw new AssertionError();
        }
        ++this.nbOfConstraints;
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            stringBuffer.append(iVecInt2.get(n2));
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n2));
            stringBuffer.append(" ");
            ++n2;
        }
        stringBuffer.append("= ");
        stringBuffer.append(n);
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        ++this.nbOfConstraints;
        int n = 0;
        while (n < iVecInt.size()) {
            stringBuffer.append(iVec.get(n));
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n));
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append("= ");
        stringBuffer.append(bigInteger);
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }
}

