/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Clauses;
import org.sat4j.minisat.core.Constr;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.ICardConstructor;
import org.sat4j.pb.constraints.IClauseConstructor;
import org.sat4j.pb.constraints.IPBConstructor;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public abstract class AbstractPBClauseCardConstrDataStructure
extends AbstractPBDataStructureFactory {
    private static final long serialVersionUID = 1L;
    static final BigInteger MAX_INT_VALUE;
    private final IPBConstructor ipbc;
    private final ICardConstructor icardc;
    private final IClauseConstructor iclausec;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.AbstractPBClauseCardConstrDataStructure");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        MAX_INT_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    }

    AbstractPBClauseCardConstrDataStructure(IClauseConstructor iClauseConstructor, ICardConstructor iCardConstructor, IPBConstructor iPBConstructor) {
        this.iclausec = iClauseConstructor;
        this.icardc = iCardConstructor;
        this.ipbc = iPBConstructor;
    }

    public Constr createClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = Clauses.sanityCheck(iVecInt, this.getVocabulary(), this.solver);
        return this.constructClause(iVecInt2);
    }

    public Constr createUnregisteredClause(IVecInt iVecInt) {
        return this.constructLearntClause(iVecInt);
    }

    protected Constr constraintFactory(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        if (nArray.length == 0 && bigInteger.signum() <= 0) {
            return null;
        }
        if (bigInteger.equals(BigInteger.ONE)) {
            IVecInt iVecInt = Clauses.sanityCheck(new VecInt(nArray), this.getVocabulary(), this.solver);
            if (iVecInt == null) {
                return null;
            }
            return this.constructClause(iVecInt);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(bigIntegerArray)) {
            if (!$assertionsDisabled && bigInteger.compareTo(MAX_INT_VALUE) >= 0) {
                throw new AssertionError();
            }
            return this.constructCard(new VecInt(nArray), bigInteger.intValue());
        }
        return this.constructPB(nArray, bigIntegerArray, bigInteger);
    }

    protected Constr learntConstraintFactory(IDataStructurePB iDataStructurePB) {
        if (iDataStructurePB.getDegree().equals(BigInteger.ONE)) {
            VecInt vecInt = new VecInt();
            Vec<BigInteger> vec = new Vec<BigInteger>();
            iDataStructurePB.buildConstraintFromConflict(vecInt, vec);
            int n = iDataStructurePB.getAssertiveLiteral();
            if (n > -1) {
                int n2 = vecInt.get(n);
                vecInt.set(n, vecInt.get(0));
                vecInt.set(0, n2);
            }
            return this.constructLearntClause(vecInt);
        }
        if (iDataStructurePB.isCardinality()) {
            return this.constructLearntCard(iDataStructurePB);
        }
        return this.constructLearntPB(iDataStructurePB);
    }

    static boolean coefficientsEqualToOne(BigInteger[] bigIntegerArray) {
        int n = 0;
        while (n < bigIntegerArray.length) {
            if (!bigIntegerArray[n].equals(BigInteger.ONE)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected Constr constructClause(IVecInt iVecInt) {
        return this.iclausec.constructClause(this.solver, this.getVocabulary(), iVecInt);
    }

    protected Constr constructCard(IVecInt iVecInt, int n) throws ContradictionException {
        return this.icardc.constructCard(this.solver, this.getVocabulary(), iVecInt, n);
    }

    protected Constr constructPB(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        return this.ipbc.constructPB(this.solver, this.getVocabulary(), nArray, bigIntegerArray, bigInteger);
    }

    protected Constr constructLearntClause(IVecInt iVecInt) {
        return this.iclausec.constructLearntClause(this.getVocabulary(), iVecInt);
    }

    protected Constr constructLearntCard(IDataStructurePB iDataStructurePB) {
        return this.icardc.constructLearntCard(this.getVocabulary(), iDataStructurePB);
    }

    protected Constr constructLearntPB(IDataStructurePB iDataStructurePB) {
        return this.ipbc.constructLearntPB(this.getVocabulary(), iDataStructurePB);
    }
}

