/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.IPBConstructor;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MaxWatchPb;
import org.sat4j.pb.constraints.pb.MaxWatchPbLong;
import org.sat4j.specs.ContradictionException;

public class MaxLongWatchPBConstructor
implements IPBConstructor {
    public Constr constructLearntPB(ILits iLits, IDataStructurePB iDataStructurePB) {
        if (iDataStructurePB.isLongSufficient()) {
            return MaxWatchPbLong.normalizedWatchPbNew(iLits, iDataStructurePB);
        }
        return MaxWatchPb.normalizedWatchPbNew(iLits, iDataStructurePB);
    }

    public Constr constructPB(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        if (MaxLongWatchPBConstructor.isLongSufficient(bigIntegerArray, bigInteger)) {
            return MaxWatchPbLong.normalizedMaxWatchPbNew(unitPropagationListener, iLits, nArray, bigIntegerArray, bigInteger);
        }
        return MaxWatchPb.normalizedMaxWatchPbNew(unitPropagationListener, iLits, nArray, bigIntegerArray, bigInteger);
    }

    public static boolean isLongSufficient(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.ZERO;
        int n = 0;
        while (bigInteger2.bitLength() < 64 && n < bigIntegerArray.length) {
            bigInteger2 = bigInteger2.add(bigIntegerArray[n]);
            ++n;
        }
        return bigInteger2.bitLength() < 64;
    }
}

