/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.IPBConstructor;
import org.sat4j.pb.constraints.MinLongWatchPBConstructor;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MinWatchPb;
import org.sat4j.pb.constraints.pb.MinWatchPbLongCP;
import org.sat4j.specs.ContradictionException;

public class MinLongWatchPBCPConstructor
implements IPBConstructor {
    public Constr constructLearntPB(ILits iLits, IDataStructurePB iDataStructurePB) {
        if (iDataStructurePB.isLongSufficient()) {
            return MinWatchPbLongCP.normalizedWatchPbNew(iLits, iDataStructurePB);
        }
        return MinWatchPb.normalizedWatchPbNew(iLits, iDataStructurePB);
    }

    public Constr constructPB(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        if (MinLongWatchPBConstructor.isLongSufficient(bigIntegerArray, bigInteger)) {
            return MinWatchPbLongCP.normalizedMinWatchPbNew(unitPropagationListener, iLits, nArray, bigIntegerArray, bigInteger);
        }
        return MinWatchPb.normalizedMinWatchPbNew(unitPropagationListener, iLits, nArray, bigIntegerArray, bigInteger);
    }
}

