/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPbLong;
import org.sat4j.specs.ContradictionException;

public final class MaxWatchPbLong
extends WatchPbLong {
    private static final long serialVersionUID = 1L;
    private long watchCumul = 0L;
    private final Map<Integer, Long> litToCoeffs;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.MaxWatchPbLong");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private MaxWatchPbLong(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = 0L;
        if (this.coefs.length > 100) {
            this.litToCoeffs = new HashMap<Integer, Long>(this.coefs.length);
            int n = 0;
            while (n < this.coefs.length) {
                this.litToCoeffs.put(new Integer(this.lits[n]), new Long(this.coefs[n]));
                ++n;
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    private MaxWatchPbLong(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        super(nArray, bigIntegerArray, bigInteger);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = 0L;
        if (bigIntegerArray.length > 100) {
            this.litToCoeffs = new HashMap<Integer, Long>(bigIntegerArray.length);
            int n = 0;
            while (n < bigIntegerArray.length) {
                this.litToCoeffs.put(new Integer(nArray[n]), new Long(this.coefs[n]));
                ++n;
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    protected void computeWatches() throws ContradictionException {
        if (!$assertionsDisabled && this.watchCumul != 0L) {
            throw new AssertionError();
        }
        int n = 0;
        while (n < this.lits.length) {
            if (this.voc.isFalsified(this.lits[n])) {
                if (this.learnt) {
                    this.voc.undos(this.lits[n] ^ 1).push(this);
                    this.voc.watch(this.lits[n] ^ 1, this);
                }
            } else {
                this.voc.watch(this.lits[n] ^ 1, this);
                this.watchCumul += this.coefs[n];
            }
            ++n;
        }
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
        if (!this.learnt && this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        int n = 0;
        while (n < this.coefs.length && this.watchCumul - this.coefs[n] < this.degree) {
            if (this.voc.isUnassigned(this.lits[n]) && !unitPropagationListener.enqueue(this.lits[n], this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++n;
        }
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        long l;
        this.voc.watch(n, this);
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError((Object)(this.watchCumul + "/" + this.computeLeftSide() + ":" + this.learnt));
        }
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            l = this.coefs[n2];
        } else {
            l = this.litToCoeffs.get(new Integer(n ^ 1));
        }
        long l2 = this.watchCumul - l;
        if (l2 < this.degree) {
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        this.voc.undos(n).push(this);
        this.watchCumul = l2;
        int n3 = 0;
        long l3 = this.watchCumul - this.degree;
        while (n3 < this.coefs.length && l3 < this.coefs[n3]) {
            if (this.voc.isUnassigned(this.lits[n3]) && !unitPropagationListener.enqueue(this.lits[n3], this)) {
                if (!$assertionsDisabled && this.isSatisfiable()) {
                    throw new AssertionError();
                }
                return false;
            }
            ++n3;
        }
        if (!$assertionsDisabled && !this.learnt && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int n = 0;
        while (n < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[n])) {
                this.voc.watches(this.lits[n] ^ 1).remove(this);
            }
            if (this.voc.isSatisfied(this.lits[n])) {
                unitPropagationListener.unset(this.lits[n]);
            }
            ++n;
        }
    }

    public void undo(int n) {
        long l;
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            l = this.coefs[n2];
        } else {
            l = this.litToCoeffs.get(new Integer(n ^ 1));
        }
        this.watchCumul += l;
    }

    public static MaxWatchPbLong normalizedMaxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        MaxWatchPbLong maxWatchPbLong = new MaxWatchPbLong(iLits, nArray, bigIntegerArray, bigInteger);
        if (maxWatchPbLong.degree <= 0L) {
            return null;
        }
        maxWatchPbLong.computeWatches();
        maxWatchPbLong.computePropagation(unitPropagationListener);
        return maxWatchPbLong;
    }

    public static WatchPbLong normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MaxWatchPbLong(iLits, iDataStructurePB);
    }
}

