/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MinWatchPbLong;
import org.sat4j.pb.constraints.pb.WatchPbLong;
import org.sat4j.specs.ContradictionException;

public class MinWatchPbLongLimit
extends WatchPbLong {
    private static final long serialVersionUID = 1L;
    protected long watchCumul = 0L;
    protected long compWatchCumul = 0L;
    protected boolean[] watched;
    protected int[] watching;
    protected int watchingCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.MinWatchPbLongLimit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected MinWatchPbLongLimit(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected MinWatchPbLongLimit(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        super(nArray, bigIntegerArray, bigInteger);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected void computeWatches() throws ContradictionException {
        if (!$assertionsDisabled && this.watchCumul != 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchingCount != 0) {
            throw new AssertionError();
        }
        int n = 0;
        while (n < this.lits.length && this.watchCumulMinusValueIsLessThanDegree(this.coefs[0])) {
            if (!this.voc.isFalsified(this.lits[n])) {
                this.voc.watch(this.lits[n] ^ 1, this);
                this.watching[this.watchingCount++] = n;
                this.watched[n] = true;
                this.addToWC(this.coefs[n]);
            }
            ++n;
        }
        if (this.learnt) {
            this.watchMoreForLearntConstraint();
        }
        if (this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
    }

    private void watchMoreForLearntConstraint() {
        int n = 1;
        while (this.watchCumulMinusValueIsLessThanDegree(this.coefs[0]) && n > 0) {
            n = 0;
            int n2 = -1;
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.lits.length) {
                if (this.voc.isFalsified(this.lits[n4]) && !this.watched[n4]) {
                    ++n;
                    int n5 = this.voc.getLevel(this.lits[n4]);
                    if (n5 > n2) {
                        n3 = n4;
                        n2 = n5;
                    }
                }
                ++n4;
            }
            if (n <= 0) continue;
            if (!$assertionsDisabled && n3 < 0) {
                throw new AssertionError();
            }
            this.voc.watch(this.lits[n3] ^ 1, this);
            this.watching[this.watchingCount++] = n3;
            this.watched[n3] = true;
            this.addToWC(this.coefs[n3]);
            if (!$assertionsDisabled && --n < 0) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && this.lits.length != 1 && this.watchingCount <= 1) {
            throw new AssertionError();
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        int n = 0;
        while (n < this.lits.length && this.watchCumulMinusValueIsLessThanDegree(this.coefs[this.watching[n]])) {
            if (this.voc.isUnassigned(this.lits[n]) && !unitPropagationListener.enqueue(this.lits[n], this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++n;
        }
    }

    public static MinWatchPbLongLimit normalizedMinWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        MinWatchPbLongLimit minWatchPbLongLimit = new MinWatchPbLongLimit(iLits, nArray, bigIntegerArray, bigInteger);
        if (minWatchPbLongLimit.degree <= 0L) {
            return null;
        }
        minWatchPbLongLimit.computeWatches();
        minWatchPbLongLimit.computePropagation(unitPropagationListener);
        return minWatchPbLongLimit;
    }

    protected int nbOfWatched() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.watched.length) {
            int n3 = 0;
            while (n3 < this.watchingCount) {
                if (this.watching[n3] == n2 && !$assertionsDisabled && !this.watched[n2]) {
                    throw new AssertionError();
                }
                ++n3;
            }
            n += this.watched[n2] ? 1 : 0;
            ++n2;
        }
        return n;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchingCount <= 1) {
            throw new AssertionError();
        }
        int n2 = 0;
        while (n2 < this.watchingCount && (this.lits[this.watching[n2]] ^ 1) != n) {
            ++n2;
        }
        int n3 = this.watching[n2];
        if (!$assertionsDisabled && n != (this.lits[n3] ^ 1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.watched[n3]) {
            throw new AssertionError();
        }
        long l = this.maximalCoefficient(n3);
        l = this.updateWatched(l, n3);
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        if (this.watchCumulMinusValueIsLessThanDegree(this.coefs[n3])) {
            this.voc.watch(n, this);
            if (!$assertionsDisabled && !this.watched[n3]) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        if (!$assertionsDisabled && Long.MAX_VALUE - this.coefs[n3] <= l) {
            throw new AssertionError();
        }
        if (this.watchCumulMinusValueIsLessThanDegree(this.coefs[n3] + l)) {
            if (!$assertionsDisabled && this.watchingCount == 0) {
                throw new AssertionError();
            }
            int n4 = 0;
            while (n4 < this.watchingCount) {
                if (!$assertionsDisabled && Long.MAX_VALUE - this.coefs[n3] <= this.coefs[this.watching[n4]]) {
                    throw new AssertionError();
                }
                if (this.watchCumulMinusValueIsLessThanDegree(this.coefs[n3] + this.coefs[this.watching[n4]]) && n4 != n2 && !this.voc.isSatisfied(this.lits[this.watching[n4]]) && !unitPropagationListener.enqueue(this.lits[this.watching[n4]], this)) {
                    this.voc.watch(n, this);
                    if (!$assertionsDisabled && this.isSatisfiable()) {
                        throw new AssertionError();
                    }
                    return false;
                }
                ++n4;
            }
        }
        this.voc.undos(n).push(this);
        this.watched[n3] = false;
        this.substractToWC(this.coefs[n3]);
        this.watching[n2] = this.watching[--this.watchingCount];
        if (!$assertionsDisabled && this.watchingCount == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int n = 0;
        while (n < this.watchingCount) {
            this.voc.watches(this.lits[this.watching[n]] ^ 1).remove(this);
            this.watched[this.watching[n]] = false;
            ++n;
        }
        this.watchingCount = 0;
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        n = 0;
        while (n < this.coefs.length && this.watchCumulMinusValueIsLessThanDegree(this.coefs[n])) {
            unitPropagationListener.unset(this.lits[n]);
            ++n;
        }
    }

    public void undo(int n) {
        this.voc.watch(n, this);
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        if (!$assertionsDisabled && n2 >= this.lits.length) {
            throw new AssertionError();
        }
        this.addToWC(this.coefs[n2]);
        if (!$assertionsDisabled && this.watchingCount != this.nbOfWatched()) {
            throw new AssertionError();
        }
        this.watched[n2] = true;
        this.watching[this.watchingCount++] = n2;
        if (!$assertionsDisabled && this.watchingCount != this.nbOfWatched()) {
            throw new AssertionError();
        }
    }

    public static WatchPbLong normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MinWatchPbLong(iLits, iDataStructurePB);
    }

    protected long maximalCoefficient(int n) {
        long l = 0L;
        int n2 = 0;
        while (n2 < this.watchingCount) {
            if (this.coefs[this.watching[n2]] > l && this.watching[n2] != n) {
                l = this.coefs[this.watching[n2]];
            }
            ++n2;
        }
        if (!$assertionsDisabled && !this.learnt && l == 0L) {
            throw new AssertionError();
        }
        return l;
    }

    protected long updateWatched(long l, int n) {
        long l2 = l;
        if (this.watchingCount < this.size()) {
            long l3 = 0L;
            long l4 = 0L;
            if (this.compWatchCumul > 0L) {
                if (!$assertionsDisabled && this.watchCumul != Long.MAX_VALUE) {
                    throw new AssertionError();
                }
                l4 = this.compWatchCumul - this.coefs[n];
                if (l4 < 0L) {
                    l3 = Long.MAX_VALUE - l4;
                    l4 = 0L;
                }
            } else {
                l3 = this.watchCumul - this.coefs[n];
            }
            long l5 = 0L;
            long l6 = 0L;
            if (Long.MAX_VALUE - this.degree < l2) {
                l5 = Long.MAX_VALUE;
                l6 = l2 - (Long.MAX_VALUE - this.degree);
            } else {
                l5 = this.degree + l2;
            }
            int n2 = 0;
            while (n2 < this.lits.length) {
                if (l4 == 0L && l6 == 0L && l3 >= l5 || l4 > l6 || l4 == l6 && l3 == l5) break;
                if (!this.voc.isFalsified(this.lits[n2]) && !this.watched[n2]) {
                    if (Long.MAX_VALUE - this.coefs[n2] >= l3) {
                        l3 += this.coefs[n2];
                    } else {
                        l4 = this.coefs[n2] - (Long.MAX_VALUE - l3);
                        l3 = Long.MAX_VALUE;
                    }
                    this.watched[n2] = true;
                    if (!$assertionsDisabled && this.watchingCount >= this.size()) {
                        throw new AssertionError();
                    }
                    this.watching[this.watchingCount++] = n2;
                    this.voc.watch(this.lits[n2] ^ 1, this);
                    if (this.coefs[n2] > l2) {
                        l2 = this.coefs[n2];
                        l6 = 0L;
                        if (Long.MAX_VALUE - this.degree < l2) {
                            l5 = Long.MAX_VALUE;
                            l6 = l2 - (Long.MAX_VALUE - this.degree);
                        } else {
                            l5 = this.degree + l2;
                        }
                    }
                }
                ++n2;
            }
            this.watchCumul = l3;
            this.compWatchCumul = l4;
            this.addToWC(this.coefs[n]);
        }
        return l2;
    }

    private boolean watchCumulMinusValueIsLessThanDegree(long l) {
        return this.watchCumul - l < this.degree && this.watchCumul != Long.MAX_VALUE || this.compWatchCumul - l > 0L || this.watchCumul - l + this.compWatchCumul < this.degree;
    }

    private void addToWC(long l) {
        if (Long.MAX_VALUE - l >= this.watchCumul) {
            this.watchCumul += l;
        } else {
            this.compWatchCumul = l - (Long.MAX_VALUE - this.watchCumul);
            this.watchCumul = Long.MAX_VALUE;
        }
    }

    private void substractToWC(long l) {
        if (this.compWatchCumul == 0L) {
            this.watchCumul -= l;
        } else {
            this.compWatchCumul -= l;
            if (this.compWatchCumul < 0L) {
                this.watchCumul -= this.compWatchCumul;
                this.compWatchCumul = 0L;
            }
        }
    }
}

