/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import java.math.BigInteger;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.Vec;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolverStats;
import org.sat4j.pb.orders.IOrderObjective;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PBSolver
extends Solver<PBDataStructureFactory>
implements IPBSolver {
    private ObjectiveFunction objf;
    private static final long serialVersionUID = 1L;
    protected PBSolverStats stats = new PBSolverStats();
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.core.PBSolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PBSolver(LearningStrategy<PBDataStructureFactory> learningStrategy, PBDataStructureFactory pBDataStructureFactory, IOrder iOrder, RestartStrategy restartStrategy) {
        super(learningStrategy, pBDataStructureFactory, iOrder, restartStrategy);
        this.initStats(this.stats);
    }

    public PBSolver(LearningStrategy<PBDataStructureFactory> learningStrategy, PBDataStructureFactory pBDataStructureFactory, SearchParams searchParams, IOrder iOrder, RestartStrategy restartStrategy) {
        super(learningStrategy, pBDataStructureFactory, searchParams, iOrder, restartStrategy);
        this.initStats(this.stats);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        if (!$assertionsDisabled && iVecInt2.size() != iVecInt.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, bl, bigInteger));
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.objf = objectiveFunction;
        IOrder iOrder = this.getOrder();
        if (iOrder instanceof IOrderObjective) {
            ((IOrderObjective)iOrder).setObjectiveFunction(objectiveFunction);
        }
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.objf;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt2.size());
        int n2 = 0;
        while (n2 < iVecInt2.size()) {
            vec.push(BigInteger.valueOf(iVecInt2.get(n2)));
            ++n2;
        }
        return this.addAtMost(iVecInt, vec, BigInteger.valueOf(n));
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        if (!$assertionsDisabled && iVecInt2.size() != iVecInt.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, false, bigInteger));
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt2.size());
        int n2 = 0;
        while (n2 < iVecInt2.size()) {
            vec.push(BigInteger.valueOf(iVecInt2.get(n2)));
            ++n2;
        }
        return this.addAtLeast(iVecInt, vec, BigInteger.valueOf(n));
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        if (!$assertionsDisabled && iVecInt2.size() != iVecInt.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, true, bigInteger));
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt2.size());
        int n2 = 0;
        while (n2 < iVecInt2.size()) {
            vec.push(BigInteger.valueOf(iVecInt2.get(n2)));
            ++n2;
        }
        return this.addExactly(iVecInt, vec, BigInteger.valueOf(n));
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        if (!$assertionsDisabled && iVecInt2.size() != iVecInt.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        ConstrGroup constrGroup = new ConstrGroup(false);
        constrGroup.add(this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, false, bigInteger)));
        constrGroup.add(this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, true, bigInteger)));
        return constrGroup;
    }
}

