/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat.reader;

import java.io.IOException;
import java.math.BigInteger;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;

public class WDimacsReader
extends DimacsReader {
    protected BigInteger weight;
    protected BigInteger top;
    private static final long serialVersionUID = 1L;
    private final WeightedMaxSatDecorator decorator;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.maxsat.reader.WDimacsReader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected void flushConstraint() throws ContradictionException {
        block2: {
            try {
                this.decorator.addSoftClause(this.weight, this.literals);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!this.isVerbose()) break block2;
                System.err.println("c Skipping constraint " + this.literals);
            }
        }
    }

    protected boolean handleLine() throws ContradictionException, IOException, ParseFormatException {
        this.weight = this.scanner.nextBigInteger();
        return super.handleLine();
    }

    public WDimacsReader(WeightedMaxSatDecorator weightedMaxSatDecorator) {
        super((ISolver)weightedMaxSatDecorator, "wcnf");
        this.decorator = weightedMaxSatDecorator;
    }

    public WDimacsReader(WeightedMaxSatDecorator weightedMaxSatDecorator, String string) {
        super((ISolver)weightedMaxSatDecorator, string);
        this.decorator = weightedMaxSatDecorator;
    }

    protected void readProblemLine() throws IOException, ParseFormatException {
        String string = this.scanner.nextLine().trim();
        if (string == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected");
        }
        String[] stringArray = string.split("\\s+");
        if (stringArray.length < 4 || !"p".equals(stringArray[0]) || !this.formatString.equals(stringArray[1])) {
            throw new ParseFormatException("problem line expected (p cnf ...)");
        }
        int n = Integer.parseInt(stringArray[2]);
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        this.solver.newVar(n);
        this.expectedNbOfConstr = Integer.parseInt(stringArray[3]);
        if (!$assertionsDisabled && this.expectedNbOfConstr <= 0) {
            throw new AssertionError();
        }
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
        if ("wcnf".equals(this.formatString)) {
            this.top = stringArray.length == 5 ? new BigInteger(stringArray[4]) : WeightedMaxSatDecorator.SAT4J_MAX_BIG_INTEGER;
            this.decorator.setTopWeight(this.top);
        }
    }
}

