/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class MinCostDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int[] costs;
    private int[] prevmodel;
    private final IVecInt vars = new VecInt();
    private final IVec<BigInteger> coeffs = new Vec();
    private int objectivevalue;
    private IConstr prevConstr;
    private boolean isSolutionOptimal;

    public MinCostDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    public int newVar() {
        throw new UnsupportedOperationException();
    }

    public int newVar(int n) {
        this.costs = new int[n + 1];
        this.vars.clear();
        this.coeffs.clear();
        for (int i = 1; i <= n; ++i) {
            this.vars.push(i);
            this.coeffs.push((Object)BigInteger.ZERO);
        }
        return super.newVar(n);
    }

    public int costOf(int n) {
        return this.costs[n];
    }

    public void setCost(int n, int n2) {
        this.costs[n] = n2;
        this.coeffs.set(n - 1, (Object)BigInteger.valueOf(n2));
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        this.isSolutionOptimal = false;
        boolean bl = super.isSatisfiable(iVecInt, true);
        if (bl) {
            this.prevmodel = super.model();
            this.calculateObjective();
        } else {
            this.isSolutionOptimal = true;
        }
        return bl;
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        this.objectivevalue = this.calculateDegree(this.prevmodel);
        return new Integer(this.objectivevalue);
    }

    private int calculateDegree(int[] nArray) {
        int n = 0;
        for (int i = 1; i < this.costs.length; ++i) {
            if (nArray[i - 1] <= 0) continue;
            n += this.costs[i];
        }
        return n;
    }

    public void discardCurrentSolution() throws ContradictionException {
        if (this.prevConstr != null) {
            super.removeSubsumedConstr(this.prevConstr);
        }
        try {
            this.prevConstr = super.addPseudoBoolean(this.vars, this.coeffs, false, BigInteger.valueOf(this.objectivevalue - 1));
        }
        catch (ContradictionException contradictionException) {
            this.isSolutionOptimal = true;
            throw contradictionException;
        }
    }

    public void reset() {
        this.prevConstr = null;
        super.reset();
    }

    public int[] model() {
        return this.prevmodel;
    }

    public Number getObjectiveValue() {
        return this.objectivevalue;
    }

    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        super.addPseudoBoolean(this.vars, this.coeffs, false, (BigInteger)number);
    }

    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }
}

