/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractOptimizationLauncher;
import org.sat4j.maxsat.MinCostDecorator;
import org.sat4j.maxsat.SolverFactory;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.reader.WDimacsReader;
import org.sat4j.opt.MinOneDecorator;
import org.sat4j.pb.ConstraintRelaxingPseudoOptDecorator;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.SolverDecorator;

public class GenericOptLauncher
extends AbstractOptimizationLauncher {
    private static final long serialVersionUID = 1L;
    private WeightedMaxSatDecorator wmsd;

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("p", "parallel", false, "uses CP and RES pseudo-boolean solvers in parallel");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("k", "kind", true, "kind of problem: minone, maxsat, etc.");
        options.addOption("i", "incomplete", false, "incomplete mode for maxsat");
        options.addOption("c", "clean databases", false, "clean up the database at root level");
        options.addOption("k", "keep Hot", false, "Keep heuristics accross calls to the SAT solver");
        options.addOption("e", "equivalence", false, "Use an equivalence instead of an implication for the selector variables");
        options.addOption("n", "no solution line", false, "Do not display a solution line (useful if the solution is large)");
        options.addOption("l", "lower bounding", false, "search solution by lower bounding instead of by upper bounding");
        options.addOption("m", "mystery", false, "mystery option");
        return options;
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    public void usage() {
        this.out.println("java -jar sat4j-maxsat.jar instance-name");
    }

    protected Reader createReader(ISolver iSolver, String string) {
        DimacsReader dimacsReader = string.contains(".wcnf") ? new WDimacsReader(this.wmsd) : new DimacsReader(this.wmsd);
        dimacsReader.setVerbosity(true);
        return dimacsReader;
    }

    protected String getInstanceName(String[] stringArray) {
        return stringArray[stringArray.length - 1];
    }

    protected ISolver configureSolver(String[] stringArray) {
        SolverDecorator solverDecorator = null;
        Options options = this.createCLIOptions();
        if (stringArray.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j-maxsat.jar", options, true);
        } else {
            try {
                String string;
                CommandLine commandLine = new PosixParser().parse(options, stringArray);
                int n = stringArray.length - 1;
                this.setDisplaySolutionLine(!commandLine.hasOption("n"));
                boolean bl = commandLine.hasOption("e");
                String string2 = commandLine.getOptionValue("k");
                if (string2 == null) {
                    string2 = "maxsat";
                }
                if ("minone".equalsIgnoreCase(string2)) {
                    solverDecorator = new MinOneDecorator(SolverFactory.newDefault());
                } else if ("mincost".equalsIgnoreCase(string2) || stringArray[n].endsWith(".p2cnf")) {
                    solverDecorator = new MinCostDecorator(SolverFactory.newDefault());
                } else {
                    assert ("maxsat".equalsIgnoreCase(string2));
                    this.wmsd = commandLine.hasOption("m") ? new WeightedMaxSatDecorator(org.sat4j.pb.SolverFactory.newSATUNSAT(), bl) : (commandLine.hasOption("p") ? new WeightedMaxSatDecorator(org.sat4j.pb.SolverFactory.newBoth(), bl) : new WeightedMaxSatDecorator(SolverFactory.newDefault(), bl));
                    solverDecorator = commandLine.hasOption("l") ? new ConstraintRelaxingPseudoOptDecorator(this.wmsd) : new PseudoOptDecorator(this.wmsd, false, !bl);
                }
                if (commandLine.hasOption("i")) {
                    this.setIncomplete(true);
                }
                if (commandLine.hasOption("c")) {
                    solverDecorator.setDBSimplificationAllowed(true);
                }
                if (commandLine.hasOption("k")) {
                    solverDecorator.setKeepSolverHot(true);
                }
                if ((string = commandLine.getOptionValue("t")) == null) {
                    string = commandLine.getOptionValue("T");
                    if (string != null) {
                        solverDecorator.setTimeoutMs(Long.parseLong(string));
                    }
                } else {
                    solverDecorator.setTimeout(Integer.parseInt(string));
                }
                this.getLogWriter().println(solverDecorator.toString("c "));
            }
            catch (ParseException parseException) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("java -jar sat4jopt.jar", options, true);
            }
        }
        return solverDecorator;
    }

    public static void main(String[] stringArray) {
        GenericOptLauncher genericOptLauncher = new GenericOptLauncher();
        genericOptLauncher.run(stringArray);
    }
}

