/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.sat4j.AbstractOptimizationLauncher;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.core.ICDCLLogger;
import org.sat4j.pb.ConstraintRelaxingPseudoOptDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.SolverFactory;
import org.sat4j.pb.reader.OPBReader2006;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.ConflictDepthTracing;
import org.sat4j.tools.ConflictLevelTracing;
import org.sat4j.tools.DecisionTracing;
import org.sat4j.tools.FileBasedVisualizationTool;
import org.sat4j.tools.LearnedClausesSizeTracing;
import org.sat4j.tools.MultiTracing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanceurPseudo2005
extends AbstractOptimizationLauncher
implements ICDCLLogger {
    ASolverFactory<IPBSolver> factory;
    private static final long serialVersionUID = 1L;
    protected ObjectiveFunction obfct;

    public LanceurPseudo2005() {
        this(SolverFactory.instance());
    }

    LanceurPseudo2005(ASolverFactory<IPBSolver> aSolverFactory) {
        this.factory = aSolverFactory;
    }

    public static void main(String[] stringArray) {
        LanceurPseudo2005 lanceurPseudo2005 = new LanceurPseudo2005();
        lanceurPseudo2005.run(stringArray);
        System.exit(lanceurPseudo2005.getExitCode().value());
    }

    @Override
    protected Reader createReader(ISolver iSolver, String string) {
        return new OPBReader2006((IPBSolver)iSolver);
    }

    @Override
    protected ISolver configureSolver(String[] stringArray) {
        String string = stringArray[0];
        boolean bl = false;
        if (string.startsWith("Trace")) {
            bl = true;
            string = string.substring("Trace".length());
        }
        boolean bl2 = false;
        if (string.startsWith("Lower")) {
            bl2 = true;
            string = string.substring("Lower".length());
        }
        IPBSolver iPBSolver = stringArray.length > 1 ? this.factory.createSolverByName(string) : this.factory.defaultSolver();
        iPBSolver = bl2 ? new ConstraintRelaxingPseudoOptDecorator(iPBSolver) : new PseudoOptDecorator(iPBSolver);
        if (stringArray.length == 3) {
            iPBSolver.setTimeout(Integer.valueOf(stringArray[1]));
        }
        if (bl) {
            String string2 = stringArray[stringArray.length - 1];
            iPBSolver.setSearchListener(new MultiTracing(new ConflictLevelTracing(new FileBasedVisualizationTool(string2 + "-conflict-level"), new FileBasedVisualizationTool(string2 + "-conflict-level-restart"), new FileBasedVisualizationTool(string2 + "-conflict-level-clean")), new DecisionTracing(new FileBasedVisualizationTool(string2 + "-decision-indexes-pos"), new FileBasedVisualizationTool(string2 + "-decision-indexes-neg"), new FileBasedVisualizationTool(string2 + "-decision-indexes-restart"), new FileBasedVisualizationTool(string2 + "-decision-indexes-clean")), new LearnedClausesSizeTracing(new FileBasedVisualizationTool(string2 + "-learned-clauses-size"), new FileBasedVisualizationTool(string2 + "-learned-clauses-size-restart"), new FileBasedVisualizationTool(string2 + "-learned-clauses-size-clean")), new ConflictDepthTracing(new FileBasedVisualizationTool(string2 + "-conflict-depth"), new FileBasedVisualizationTool(string2 + "-conflict-depth-restart"), new FileBasedVisualizationTool(string2 + "-conflict-depth-clean"))));
        }
        this.out.println(iPBSolver.toString("c "));
        return iPBSolver;
    }

    @Override
    public void usage() {
        this.out.println("java -jar sat4j-pb.jar [solvername [timeout]] instancename.opb");
        this.showAvailableSolvers(SolverFactory.instance());
    }

    @Override
    protected String getInstanceName(String[] stringArray) {
        assert (stringArray.length == 1 || stringArray.length == 2 || stringArray.length == 3);
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[stringArray.length - 1];
    }

    @Override
    protected IProblem readProblem(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        IProblem iProblem = super.readProblem(string);
        ObjectiveFunction objectiveFunction = ((IPBSolver)iProblem).getObjectiveFunction();
        if (objectiveFunction != null) {
            this.out.println("c objective function length is " + objectiveFunction.getVars().size() + " literals");
        }
        return iProblem;
    }
}

