/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.ReadOnlyVec;
import org.sat4j.core.ReadOnlyVecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IVec<BigInteger> coeffs;
    private final IVecInt vars;
    private BigInteger correction = BigInteger.ZERO;

    public ObjectiveFunction(IVecInt iVecInt, IVec<BigInteger> iVec) {
        this.vars = new ReadOnlyVecInt(iVecInt);
        this.coeffs = new ReadOnlyVec<BigInteger>(iVec);
    }

    public BigInteger calculateDegree(ISolver iSolver) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.vars.size(); ++i) {
            BigInteger bigInteger2 = this.coeffs.get(i);
            if (this.varInModel(this.vars.get(i), iSolver)) {
                bigInteger = bigInteger.add(bigInteger2);
                continue;
            }
            if (bigInteger2.signum() >= 0 || this.varInModel(-this.vars.get(i), iSolver)) continue;
            bigInteger = bigInteger.add(bigInteger2);
        }
        return bigInteger;
    }

    public BigInteger calculateDegreeImplicant(ISolver iSolver) {
        BigInteger bigInteger = BigInteger.ZERO;
        iSolver.primeImplicant();
        for (int i = 0; i < this.vars.size(); ++i) {
            BigInteger bigInteger2 = this.coeffs.get(i);
            if (iSolver.primeImplicant(this.vars.get(i))) {
                bigInteger = bigInteger.add(bigInteger2);
                continue;
            }
            if (bigInteger2.signum() >= 0 || iSolver.primeImplicant(-this.vars.get(i))) continue;
            bigInteger = bigInteger.add(bigInteger2);
        }
        return bigInteger;
    }

    private boolean varInModel(int n, ISolver iSolver) {
        if (n > 0) {
            return iSolver.model(n);
        }
        return !iSolver.model(-n);
    }

    public IVec<BigInteger> getCoeffs() {
        return this.coeffs;
    }

    public IVecInt getVars() {
        return this.vars;
    }

    public void setCorrection(BigInteger bigInteger) {
        this.correction = bigInteger;
    }

    public BigInteger getCorrection() {
        return this.correction;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        IVecInt iVecInt = this.getVars();
        IVec<BigInteger> iVec = this.getCoeffs();
        for (int i = 0; i < iVecInt.size(); ++i) {
            BigInteger bigInteger = iVec.get(i);
            int n = iVecInt.get(i);
            if (n < 0) {
                n = -n;
                bigInteger = bigInteger.negate();
            }
            stringBuffer.append((bigInteger.signum() < 0 ? "" : "+") + bigInteger + " x" + n + " ");
        }
        return stringBuffer.toString();
    }

    public BigInteger minValue() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.vars.size(); ++i) {
            BigInteger bigInteger2 = this.coeffs.get(i);
            if (bigInteger2.signum() >= 0) continue;
            bigInteger = bigInteger.add(bigInteger2);
        }
        return bigInteger;
    }

    public BigInteger calculateDegree(int[] nArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.vars.size(); ++i) {
            BigInteger bigInteger2 = this.coeffs.get(i);
            if (this.varInModel(this.vars.get(i), nArray)) {
                bigInteger = bigInteger.add(bigInteger2);
                continue;
            }
            if (bigInteger2.signum() >= 0 || this.varInModel(-this.vars.get(i), nArray)) continue;
            bigInteger = bigInteger.add(bigInteger2);
        }
        return bigInteger;
    }

    private boolean varInModel(int n, int[] nArray) {
        for (int n2 : nArray) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }
}

